/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.client;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class InMemoryRegisteredClientRepository
implements RegisteredClientRepository {
    private final Map<String, RegisteredClient> idRegistrationMap;
    private final Map<String, RegisteredClient> clientIdRegistrationMap;

    public InMemoryRegisteredClientRepository(RegisteredClient ... registrations) {
        this(Arrays.asList(registrations));
    }

    public InMemoryRegisteredClientRepository(List<RegisteredClient> registrations) {
        Assert.notEmpty(registrations, (String)"registrations cannot be empty");
        ConcurrentHashMap<String, RegisteredClient> idRegistrationMapResult = new ConcurrentHashMap<String, RegisteredClient>();
        ConcurrentHashMap<String, RegisteredClient> clientIdRegistrationMapResult = new ConcurrentHashMap<String, RegisteredClient>();
        for (RegisteredClient registration : registrations) {
            Assert.notNull((Object)registration, (String)"registration cannot be null");
            this.assertUniqueIdentifiers(registration, idRegistrationMapResult);
            idRegistrationMapResult.put(registration.getId(), registration);
            clientIdRegistrationMapResult.put(registration.getClientId(), registration);
        }
        this.idRegistrationMap = idRegistrationMapResult;
        this.clientIdRegistrationMap = clientIdRegistrationMapResult;
    }

    @Override
    public void save(RegisteredClient registeredClient) {
        Assert.notNull((Object)registeredClient, (String)"registeredClient cannot be null");
        this.assertUniqueIdentifiers(registeredClient, this.idRegistrationMap);
        this.idRegistrationMap.put(registeredClient.getId(), registeredClient);
        this.clientIdRegistrationMap.put(registeredClient.getClientId(), registeredClient);
    }

    @Override
    @Nullable
    public RegisteredClient findById(String id) {
        Assert.hasText((String)id, (String)"id cannot be empty");
        return this.idRegistrationMap.get(id);
    }

    @Override
    @Nullable
    public RegisteredClient findByClientId(String clientId) {
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        return this.clientIdRegistrationMap.get(clientId);
    }

    private void assertUniqueIdentifiers(RegisteredClient registeredClient, Map<String, RegisteredClient> registrations) {
        registrations.values().forEach(registration -> {
            if (registeredClient.getId().equals(registration.getId())) {
                throw new IllegalArgumentException("Registered client must be unique. Found duplicate identifier: " + registeredClient.getId());
            }
            if (registeredClient.getClientId().equals(registration.getClientId())) {
                throw new IllegalArgumentException("Registered client must be unique. Found duplicate client identifier: " + registeredClient.getClientId());
            }
            if (StringUtils.hasText((String)registeredClient.getClientSecret()) && registeredClient.getClientSecret().equals(registration.getClientSecret())) {
                throw new IllegalArgumentException("Registered client must be unique. Found duplicate client secret for identifier: " + registeredClient.getId());
            }
        });
    }
}

