/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.ConfigurationSettingNames;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcRegisteredClientRepository
implements RegisteredClientRepository {
    private static final String COLUMN_NAMES = "id, client_id, client_id_issued_at, client_secret, client_secret_expires_at, client_name, client_authentication_methods, authorization_grant_types, redirect_uris, scopes, client_settings,token_settings";
    private static final String TABLE_NAME = "oauth2_registered_client";
    private static final String PK_FILTER = "id = ?";
    private static final String LOAD_REGISTERED_CLIENT_SQL = "SELECT id, client_id, client_id_issued_at, client_secret, client_secret_expires_at, client_name, client_authentication_methods, authorization_grant_types, redirect_uris, scopes, client_settings,token_settings FROM oauth2_registered_client WHERE ";
    private static final String INSERT_REGISTERED_CLIENT_SQL = "INSERT INTO oauth2_registered_client(id, client_id, client_id_issued_at, client_secret, client_secret_expires_at, client_name, client_authentication_methods, authorization_grant_types, redirect_uris, scopes, client_settings,token_settings) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_REGISTERED_CLIENT_SQL = "UPDATE oauth2_registered_client SET client_name = ?, client_authentication_methods = ?, authorization_grant_types = ?, redirect_uris = ?, scopes = ?, client_settings = ?, token_settings = ? WHERE id = ?";
    private static final String COUNT_REGISTERED_CLIENT_SQL = "SELECT COUNT(*) FROM oauth2_registered_client WHERE ";
    private final JdbcOperations jdbcOperations;
    private RowMapper<RegisteredClient> registeredClientRowMapper;
    private Function<RegisteredClient, List<SqlParameterValue>> registeredClientParametersMapper;

    public JdbcRegisteredClientRepository(JdbcOperations jdbcOperations) {
        Assert.notNull((Object)jdbcOperations, (String)"jdbcOperations cannot be null");
        this.jdbcOperations = jdbcOperations;
        this.registeredClientRowMapper = new RegisteredClientRowMapper();
        this.registeredClientParametersMapper = new RegisteredClientParametersMapper();
    }

    @Override
    public void save(RegisteredClient registeredClient) {
        Assert.notNull((Object)registeredClient, (String)"registeredClient cannot be null");
        RegisteredClient existingRegisteredClient = this.findBy(PK_FILTER, registeredClient.getId());
        if (existingRegisteredClient != null) {
            this.updateRegisteredClient(registeredClient);
        } else {
            this.insertRegisteredClient(registeredClient);
        }
    }

    private void updateRegisteredClient(RegisteredClient registeredClient) {
        ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>((Collection)this.registeredClientParametersMapper.apply(registeredClient));
        SqlParameterValue id = (SqlParameterValue)parameters.remove(0);
        parameters.remove(0);
        parameters.remove(0);
        parameters.remove(0);
        parameters.remove(0);
        parameters.add(id);
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters.toArray());
        this.jdbcOperations.update(UPDATE_REGISTERED_CLIENT_SQL, (PreparedStatementSetter)pss);
    }

    private void insertRegisteredClient(RegisteredClient registeredClient) {
        this.assertUniqueIdentifiers(registeredClient);
        List<SqlParameterValue> parameters = this.registeredClientParametersMapper.apply(registeredClient);
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters.toArray());
        this.jdbcOperations.update(INSERT_REGISTERED_CLIENT_SQL, (PreparedStatementSetter)pss);
    }

    private void assertUniqueIdentifiers(RegisteredClient registeredClient) {
        Integer count = (Integer)this.jdbcOperations.queryForObject("SELECT COUNT(*) FROM oauth2_registered_client WHERE client_id = ?", Integer.class, new Object[]{registeredClient.getClientId()});
        if (count != null && count > 0) {
            throw new IllegalArgumentException("Registered client must be unique. Found duplicate client identifier: " + registeredClient.getClientId());
        }
        count = (Integer)this.jdbcOperations.queryForObject("SELECT COUNT(*) FROM oauth2_registered_client WHERE client_secret = ?", Integer.class, new Object[]{registeredClient.getClientSecret()});
        if (count != null && count > 0) {
            throw new IllegalArgumentException("Registered client must be unique. Found duplicate client secret for identifier: " + registeredClient.getId());
        }
    }

    @Override
    public RegisteredClient findById(String id) {
        Assert.hasText((String)id, (String)"id cannot be empty");
        return this.findBy(PK_FILTER, id);
    }

    @Override
    public RegisteredClient findByClientId(String clientId) {
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        return this.findBy("client_id = ?", clientId);
    }

    private RegisteredClient findBy(String filter, Object ... args) {
        List result = this.jdbcOperations.query(LOAD_REGISTERED_CLIENT_SQL + filter, this.registeredClientRowMapper, args);
        return !result.isEmpty() ? (RegisteredClient)result.get(0) : null;
    }

    public final void setRegisteredClientRowMapper(RowMapper<RegisteredClient> registeredClientRowMapper) {
        Assert.notNull(registeredClientRowMapper, (String)"registeredClientRowMapper cannot be null");
        this.registeredClientRowMapper = registeredClientRowMapper;
    }

    public final void setRegisteredClientParametersMapper(Function<RegisteredClient, List<SqlParameterValue>> registeredClientParametersMapper) {
        Assert.notNull(registeredClientParametersMapper, (String)"registeredClientParametersMapper cannot be null");
        this.registeredClientParametersMapper = registeredClientParametersMapper;
    }

    protected final JdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    protected final RowMapper<RegisteredClient> getRegisteredClientRowMapper() {
        return this.registeredClientRowMapper;
    }

    protected final Function<RegisteredClient, List<SqlParameterValue>> getRegisteredClientParametersMapper() {
        return this.registeredClientParametersMapper;
    }

    public static class RegisteredClientRowMapper
    implements RowMapper<RegisteredClient> {
        private ObjectMapper objectMapper = new ObjectMapper();

        public RegisteredClientRowMapper() {
            ClassLoader classLoader = JdbcRegisteredClientRepository.class.getClassLoader();
            List securityModules = SecurityJackson2Modules.getModules((ClassLoader)classLoader);
            this.objectMapper.registerModules((Iterable)securityModules);
            this.objectMapper.registerModule((Module)new OAuth2AuthorizationServerJackson2Module());
        }

        public RegisteredClient mapRow(ResultSet rs, int rowNum) throws SQLException {
            Timestamp clientIdIssuedAt = rs.getTimestamp("client_id_issued_at");
            Timestamp clientSecretExpiresAt = rs.getTimestamp("client_secret_expires_at");
            Set clientAuthenticationMethods = StringUtils.commaDelimitedListToSet((String)rs.getString("client_authentication_methods"));
            Set authorizationGrantTypes = StringUtils.commaDelimitedListToSet((String)rs.getString("authorization_grant_types"));
            Set redirectUris = StringUtils.commaDelimitedListToSet((String)rs.getString("redirect_uris"));
            Set clientScopes = StringUtils.commaDelimitedListToSet((String)rs.getString("scopes"));
            RegisteredClient.Builder builder = RegisteredClient.withId(rs.getString("id")).clientId(rs.getString("client_id")).clientIdIssuedAt(clientIdIssuedAt != null ? clientIdIssuedAt.toInstant() : null).clientSecret(rs.getString("client_secret")).clientSecretExpiresAt(clientSecretExpiresAt != null ? clientSecretExpiresAt.toInstant() : null).clientName(rs.getString("client_name")).clientAuthenticationMethods(authenticationMethods -> clientAuthenticationMethods.forEach(authenticationMethod -> authenticationMethods.add(RegisteredClientRowMapper.resolveClientAuthenticationMethod(authenticationMethod)))).authorizationGrantTypes(grantTypes -> authorizationGrantTypes.forEach(grantType -> grantTypes.add(RegisteredClientRowMapper.resolveAuthorizationGrantType(grantType)))).redirectUris(uris -> uris.addAll(redirectUris)).scopes(scopes -> scopes.addAll(clientScopes));
            Map<String, Object> clientSettingsMap = this.parseMap(rs.getString("client_settings"));
            builder.clientSettings(ClientSettings.withSettings(clientSettingsMap).build());
            Map<String, Object> tokenSettingsMap = this.parseMap(rs.getString("token_settings"));
            TokenSettings.Builder tokenSettingsBuilder = TokenSettings.withSettings(tokenSettingsMap);
            if (!tokenSettingsMap.containsKey(ConfigurationSettingNames.Token.ACCESS_TOKEN_FORMAT)) {
                tokenSettingsBuilder.accessTokenFormat(OAuth2TokenFormat.SELF_CONTAINED);
            }
            builder.tokenSettings(tokenSettingsBuilder.build());
            return builder.build();
        }

        public final void setObjectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
            this.objectMapper = objectMapper;
        }

        protected final ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        private Map<String, Object> parseMap(String data) {
            try {
                return (Map)this.objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }

        private static AuthorizationGrantType resolveAuthorizationGrantType(String authorizationGrantType) {
            if (AuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(authorizationGrantType)) {
                return AuthorizationGrantType.AUTHORIZATION_CODE;
            }
            if (AuthorizationGrantType.CLIENT_CREDENTIALS.getValue().equals(authorizationGrantType)) {
                return AuthorizationGrantType.CLIENT_CREDENTIALS;
            }
            if (AuthorizationGrantType.REFRESH_TOKEN.getValue().equals(authorizationGrantType)) {
                return AuthorizationGrantType.REFRESH_TOKEN;
            }
            return new AuthorizationGrantType(authorizationGrantType);
        }

        private static ClientAuthenticationMethod resolveClientAuthenticationMethod(String clientAuthenticationMethod) {
            if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.getValue().equals(clientAuthenticationMethod)) {
                return ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
            }
            if (ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue().equals(clientAuthenticationMethod)) {
                return ClientAuthenticationMethod.CLIENT_SECRET_POST;
            }
            if (ClientAuthenticationMethod.NONE.getValue().equals(clientAuthenticationMethod)) {
                return ClientAuthenticationMethod.NONE;
            }
            return new ClientAuthenticationMethod(clientAuthenticationMethod);
        }
    }

    public static class RegisteredClientParametersMapper
    implements Function<RegisteredClient, List<SqlParameterValue>> {
        private ObjectMapper objectMapper = new ObjectMapper();

        public RegisteredClientParametersMapper() {
            ClassLoader classLoader = JdbcRegisteredClientRepository.class.getClassLoader();
            List securityModules = SecurityJackson2Modules.getModules((ClassLoader)classLoader);
            this.objectMapper.registerModules((Iterable)securityModules);
            this.objectMapper.registerModule((Module)new OAuth2AuthorizationServerJackson2Module());
        }

        @Override
        public List<SqlParameterValue> apply(RegisteredClient registeredClient) {
            Timestamp clientIdIssuedAt = registeredClient.getClientIdIssuedAt() != null ? Timestamp.from(registeredClient.getClientIdIssuedAt()) : Timestamp.from(Instant.now());
            Timestamp clientSecretExpiresAt = registeredClient.getClientSecretExpiresAt() != null ? Timestamp.from(registeredClient.getClientSecretExpiresAt()) : null;
            ArrayList clientAuthenticationMethods = new ArrayList(registeredClient.getClientAuthenticationMethods().size());
            registeredClient.getClientAuthenticationMethods().forEach(clientAuthenticationMethod -> clientAuthenticationMethods.add(clientAuthenticationMethod.getValue()));
            ArrayList authorizationGrantTypes = new ArrayList(registeredClient.getAuthorizationGrantTypes().size());
            registeredClient.getAuthorizationGrantTypes().forEach(authorizationGrantType -> authorizationGrantTypes.add(authorizationGrantType.getValue()));
            return Arrays.asList(new SqlParameterValue(12, (Object)registeredClient.getId()), new SqlParameterValue(12, (Object)registeredClient.getClientId()), new SqlParameterValue(93, (Object)clientIdIssuedAt), new SqlParameterValue(12, (Object)registeredClient.getClientSecret()), new SqlParameterValue(93, (Object)clientSecretExpiresAt), new SqlParameterValue(12, (Object)registeredClient.getClientName()), new SqlParameterValue(12, (Object)StringUtils.collectionToCommaDelimitedString(clientAuthenticationMethods)), new SqlParameterValue(12, (Object)StringUtils.collectionToCommaDelimitedString(authorizationGrantTypes)), new SqlParameterValue(12, (Object)StringUtils.collectionToCommaDelimitedString(registeredClient.getRedirectUris())), new SqlParameterValue(12, (Object)StringUtils.collectionToCommaDelimitedString(registeredClient.getScopes())), new SqlParameterValue(12, (Object)this.writeMap(registeredClient.getClientSettings().getSettings())), new SqlParameterValue(12, (Object)this.writeMap(registeredClient.getTokenSettings().getSettings())));
        }

        public final void setObjectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"objectMapper cannot be null");
            this.objectMapper = objectMapper;
        }

        protected final ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        private String writeMap(Map<String, Object> data) {
            try {
                return this.objectMapper.writeValueAsString(data);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
    }
}

