/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenIntrospectionAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OAuth2TokenIntrospectionAuthenticationConverter
implements AuthenticationConverter {
    public Authentication convert(HttpServletRequest request) {
        String tokenTypeHint;
        Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        String token = (String)parameters.getFirst((Object)"token");
        if (!StringUtils.hasText((String)token) || ((List)parameters.get((Object)"token")).size() != 1) {
            OAuth2TokenIntrospectionAuthenticationConverter.throwError("invalid_request", "token");
        }
        if (StringUtils.hasText((String)(tokenTypeHint = (String)parameters.getFirst((Object)"token_type_hint"))) && ((List)parameters.get((Object)"token_type_hint")).size() != 1) {
            OAuth2TokenIntrospectionAuthenticationConverter.throwError("invalid_request", "token_type_hint");
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!key.equals("token") && !key.equals("token_type_hint")) {
                additionalParameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0]));
            }
        });
        return new OAuth2TokenIntrospectionAuthenticationToken(token, clientPrincipal, tokenTypeHint, additionalParameters);
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Token Introspection Parameter: " + parameterName, "https://datatracker.ietf.org/doc/html/rfc7662#section-2.1");
        throw new OAuth2AuthenticationException(error);
    }
}

