/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceAuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.DefaultConsentPage;
import org.springframework.security.oauth2.server.authorization.web.authentication.DelegatingAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2DeviceAuthorizationConsentAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2DeviceVerificationAuthenticationConverter;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.util.RedirectUrlBuilder;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public final class OAuth2DeviceVerificationEndpointFilter
extends OncePerRequestFilter {
    static final String DEFAULT_DEVICE_VERIFICATION_ENDPOINT_URI = "/oauth2/device_verification";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher deviceVerificationEndpointMatcher;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationConverter authenticationConverter;
    private AuthenticationSuccessHandler authenticationSuccessHandler = new SimpleUrlAuthenticationSuccessHandler("/?success");
    private AuthenticationFailureHandler authenticationFailureHandler = this::sendErrorResponse;
    private String consentPage;

    public OAuth2DeviceVerificationEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_DEVICE_VERIFICATION_ENDPOINT_URI);
    }

    public OAuth2DeviceVerificationEndpointFilter(AuthenticationManager authenticationManager, String deviceVerificationEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)deviceVerificationEndpointUri, (String)"deviceVerificationEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.deviceVerificationEndpointMatcher = this.createDefaultRequestMatcher(deviceVerificationEndpointUri);
        this.authenticationConverter = new DelegatingAuthenticationConverter(Arrays.asList(new OAuth2DeviceVerificationAuthenticationConverter(), new OAuth2DeviceAuthorizationConsentAuthenticationConverter()));
    }

    private RequestMatcher createDefaultRequestMatcher(String deviceVerificationEndpointUri) {
        AntPathRequestMatcher verificationRequestGetMatcher = new AntPathRequestMatcher(deviceVerificationEndpointUri, HttpMethod.GET.name());
        AntPathRequestMatcher verificationRequestPostMatcher = new AntPathRequestMatcher(deviceVerificationEndpointUri, HttpMethod.POST.name());
        RequestMatcher userCodeParameterMatcher = request -> request.getParameter("user_code") != null;
        return new AndRequestMatcher(new RequestMatcher[]{new OrRequestMatcher(new RequestMatcher[]{verificationRequestGetMatcher, verificationRequestPostMatcher}), userCodeParameterMatcher});
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.deviceVerificationEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication authenticationResult;
            Authentication authentication = this.authenticationConverter.convert(request);
            if (authentication instanceof AbstractAuthenticationToken) {
                ((AbstractAuthenticationToken)authentication).setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            }
            if (!(authenticationResult = this.authenticationManager.authenticate(authentication)).isAuthenticated()) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (authenticationResult instanceof OAuth2DeviceAuthorizationConsentAuthenticationToken) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Device authorization consent is required");
                }
                this.sendAuthorizationConsent(request, response, authenticationResult);
                return;
            }
            this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, authenticationResult);
        }
        catch (OAuth2AuthenticationException ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Device verification request failed: %s", (Object)ex.getError()), (Throwable)ex);
            }
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)ex);
        }
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"authenticationDetailsSource cannot be null");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public void setConsentPage(String consentPage) {
        this.consentPage = consentPage;
    }

    private void sendAuthorizationConsent(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        OAuth2DeviceAuthorizationConsentAuthenticationToken authorizationConsentAuthentication = (OAuth2DeviceAuthorizationConsentAuthenticationToken)authentication;
        String clientId = authorizationConsentAuthentication.getClientId();
        Authentication principal = (Authentication)authorizationConsentAuthentication.getPrincipal();
        Set<String> requestedScopes = authorizationConsentAuthentication.getRequestedScopes();
        Set<String> authorizedScopes = authorizationConsentAuthentication.getScopes();
        String state = authorizationConsentAuthentication.getState();
        String userCode = authorizationConsentAuthentication.getUserCode();
        if (this.hasConsentUri()) {
            String redirectUri = UriComponentsBuilder.fromUriString((String)this.resolveConsentUri(request)).queryParam("scope", new Object[]{String.join((CharSequence)" ", requestedScopes)}).queryParam("client_id", new Object[]{clientId}).queryParam("state", new Object[]{state}).queryParam("user_code", new Object[]{userCode}).toUriString();
            this.redirectStrategy.sendRedirect(request, response, redirectUri);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Displaying generated consent screen");
            }
            HashMap<String, String> additionalParameters = new HashMap<String, String>();
            additionalParameters.put("user_code", userCode);
            DefaultConsentPage.displayConsent(request, response, clientId, principal, requestedScopes, authorizedScopes, state, additionalParameters);
        }
    }

    private boolean hasConsentUri() {
        return StringUtils.hasText((String)this.consentPage);
    }

    private String resolveConsentUri(HttpServletRequest request) {
        if (UrlUtils.isAbsoluteUrl((String)this.consentPage)) {
            return this.consentPage;
        }
        RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
        urlBuilder.setScheme(request.getScheme());
        urlBuilder.setServerName(request.getServerName());
        urlBuilder.setPort(request.getServerPort());
        urlBuilder.setContextPath(request.getContextPath());
        urlBuilder.setPathInfo(this.consentPage);
        return urlBuilder.getUrl();
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationException authenticationException) throws IOException {
        OAuth2Error error = ((OAuth2AuthenticationException)authenticationException).getError();
        response.sendError(HttpStatus.BAD_REQUEST.value(), error.toString());
    }
}

