/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationServerMetadata;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AbstractOAuth2Configurer;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationServerMetadataEndpointFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class OAuth2AuthorizationServerMetadataEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private Consumer<OAuth2AuthorizationServerMetadata.Builder> authorizationServerMetadataCustomizer;
    private Consumer<OAuth2AuthorizationServerMetadata.Builder> defaultAuthorizationServerMetadataCustomizer;

    OAuth2AuthorizationServerMetadataEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OAuth2AuthorizationServerMetadataEndpointConfigurer authorizationServerMetadataCustomizer(Consumer<OAuth2AuthorizationServerMetadata.Builder> authorizationServerMetadataCustomizer) {
        this.authorizationServerMetadataCustomizer = authorizationServerMetadataCustomizer;
        return this;
    }

    void addDefaultAuthorizationServerMetadataCustomizer(Consumer<OAuth2AuthorizationServerMetadata.Builder> defaultAuthorizationServerMetadataCustomizer) {
        this.defaultAuthorizationServerMetadataCustomizer = this.defaultAuthorizationServerMetadataCustomizer == null ? defaultAuthorizationServerMetadataCustomizer : this.defaultAuthorizationServerMetadataCustomizer.andThen(defaultAuthorizationServerMetadataCustomizer);
    }

    @Override
    void init(HttpSecurity httpSecurity) {
        this.requestMatcher = new AntPathRequestMatcher("/.well-known/oauth-authorization-server", HttpMethod.GET.name());
    }

    @Override
    void configure(HttpSecurity httpSecurity) {
        OAuth2AuthorizationServerMetadataEndpointFilter authorizationServerMetadataEndpointFilter = new OAuth2AuthorizationServerMetadataEndpointFilter();
        Consumer<OAuth2AuthorizationServerMetadata.Builder> authorizationServerMetadataCustomizer = this.getAuthorizationServerMetadataCustomizer();
        if (authorizationServerMetadataCustomizer != null) {
            authorizationServerMetadataEndpointFilter.setAuthorizationServerMetadataCustomizer(authorizationServerMetadataCustomizer);
        }
        httpSecurity.addFilterBefore((Filter)this.postProcess(authorizationServerMetadataEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
    }

    private Consumer<OAuth2AuthorizationServerMetadata.Builder> getAuthorizationServerMetadataCustomizer() {
        Consumer<OAuth2AuthorizationServerMetadata.Builder> authorizationServerMetadataCustomizer = null;
        if (this.defaultAuthorizationServerMetadataCustomizer != null || this.authorizationServerMetadataCustomizer != null) {
            if (this.defaultAuthorizationServerMetadataCustomizer != null) {
                authorizationServerMetadataCustomizer = this.defaultAuthorizationServerMetadataCustomizer;
            }
            if (this.authorizationServerMetadataCustomizer != null) {
                authorizationServerMetadataCustomizer = authorizationServerMetadataCustomizer != null ? authorizationServerMetadataCustomizer.andThen(this.authorizationServerMetadataCustomizer) : this.authorizationServerMetadataCustomizer;
            }
        }
        return authorizationServerMetadataCustomizer;
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }
}

