/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.converter;

import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.util.CollectionUtils;

public final class OidcClientRegistrationRegisteredClientConverter
implements Converter<OidcClientRegistration, RegisteredClient> {
    private static final StringKeyGenerator CLIENT_ID_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 32);
    private static final StringKeyGenerator CLIENT_SECRET_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 48);

    public RegisteredClient convert(OidcClientRegistration clientRegistration) {
        RegisteredClient.Builder builder = RegisteredClient.withId(UUID.randomUUID().toString()).clientId(CLIENT_ID_GENERATOR.generateKey()).clientIdIssuedAt(Instant.now()).clientName(clientRegistration.getClientName());
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).clientSecret(CLIENT_SECRET_GENERATOR.generateKey());
        } else if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_JWT).clientSecret(CLIENT_SECRET_GENERATOR.generateKey());
        } else if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        } else {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).clientSecret(CLIENT_SECRET_GENERATOR.generateKey());
        }
        builder.redirectUris(redirectUris -> redirectUris.addAll(clientRegistration.getRedirectUris()));
        if (!CollectionUtils.isEmpty(clientRegistration.getPostLogoutRedirectUris())) {
            builder.postLogoutRedirectUris(postLogoutRedirectUris -> postLogoutRedirectUris.addAll(clientRegistration.getPostLogoutRedirectUris()));
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getGrantTypes())) {
            builder.authorizationGrantTypes(authorizationGrantTypes -> clientRegistration.getGrantTypes().forEach(grantType -> authorizationGrantTypes.add(new AuthorizationGrantType(grantType))));
        } else {
            builder.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        }
        if (CollectionUtils.isEmpty(clientRegistration.getResponseTypes()) || clientRegistration.getResponseTypes().contains(OAuth2AuthorizationResponseType.CODE.getValue())) {
            builder.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            builder.scopes(scopes -> scopes.addAll(clientRegistration.getScopes()));
        }
        ClientSettings.Builder clientSettingsBuilder = ClientSettings.builder().requireProofKey(true).requireAuthorizationConsent(true);
        if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            MacAlgorithm macAlgorithm = MacAlgorithm.from((String)clientRegistration.getTokenEndpointAuthenticationSigningAlgorithm());
            if (macAlgorithm == null) {
                macAlgorithm = MacAlgorithm.HS256;
            }
            clientSettingsBuilder.tokenEndpointAuthenticationSigningAlgorithm((JwsAlgorithm)macAlgorithm);
        } else if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.from((String)clientRegistration.getTokenEndpointAuthenticationSigningAlgorithm());
            if (signatureAlgorithm == null) {
                signatureAlgorithm = SignatureAlgorithm.RS256;
            }
            clientSettingsBuilder.tokenEndpointAuthenticationSigningAlgorithm((JwsAlgorithm)signatureAlgorithm);
            clientSettingsBuilder.jwkSetUrl(clientRegistration.getJwkSetUrl().toString());
        }
        builder.clientSettings(clientSettingsBuilder.build()).tokenSettings(TokenSettings.builder().idTokenSignatureAlgorithm(SignatureAlgorithm.RS256).build());
        return builder.build();
    }
}

