/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContext;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public final class JwtClientAssertionDecoderFactory
implements JwtDecoderFactory<RegisteredClient> {
    public static final Function<RegisteredClient, OAuth2TokenValidator<Jwt>> DEFAULT_JWT_VALIDATOR_FACTORY = JwtClientAssertionDecoderFactory.defaultJwtValidatorFactory();
    private static final String JWT_CLIENT_AUTHENTICATION_ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc7523#section-3";
    private static final Map<JwsAlgorithm, String> JCA_ALGORITHM_MAPPINGS;
    private static final RestTemplate restTemplate;
    private final Map<String, JwtDecoder> jwtDecoders = new ConcurrentHashMap<String, JwtDecoder>();
    private Function<RegisteredClient, OAuth2TokenValidator<Jwt>> jwtValidatorFactory = DEFAULT_JWT_VALIDATOR_FACTORY;

    public JwtDecoder createDecoder(RegisteredClient registeredClient) {
        Assert.notNull((Object)registeredClient, (String)"registeredClient cannot be null");
        return this.jwtDecoders.computeIfAbsent(registeredClient.getId(), key -> {
            NimbusJwtDecoder jwtDecoder = JwtClientAssertionDecoderFactory.buildDecoder(registeredClient);
            jwtDecoder.setJwtValidator(this.jwtValidatorFactory.apply(registeredClient));
            return jwtDecoder;
        });
    }

    public void setJwtValidatorFactory(Function<RegisteredClient, OAuth2TokenValidator<Jwt>> jwtValidatorFactory) {
        Assert.notNull(jwtValidatorFactory, (String)"jwtValidatorFactory cannot be null");
        this.jwtValidatorFactory = jwtValidatorFactory;
    }

    private static NimbusJwtDecoder buildDecoder(RegisteredClient registeredClient) {
        JwsAlgorithm jwsAlgorithm = registeredClient.getClientSettings().getTokenEndpointAuthenticationSigningAlgorithm();
        if (jwsAlgorithm instanceof SignatureAlgorithm) {
            String jwkSetUrl = registeredClient.getClientSettings().getJwkSetUrl();
            if (!StringUtils.hasText((String)jwkSetUrl)) {
                OAuth2Error oauth2Error = new OAuth2Error("invalid_client", "Failed to find a Signature Verifier for Client: '" + registeredClient.getId() + "'. Check to ensure you have configured the JWK Set URL.", JWT_CLIENT_AUTHENTICATION_ERROR_URI);
                throw new OAuth2AuthenticationException(oauth2Error);
            }
            return NimbusJwtDecoder.withJwkSetUri((String)jwkSetUrl).jwsAlgorithm((SignatureAlgorithm)jwsAlgorithm).restOperations((RestOperations)restTemplate).build();
        }
        if (jwsAlgorithm instanceof MacAlgorithm) {
            String clientSecret = registeredClient.getClientSecret();
            if (!StringUtils.hasText((String)clientSecret)) {
                OAuth2Error oauth2Error = new OAuth2Error("invalid_client", "Failed to find a Signature Verifier for Client: '" + registeredClient.getId() + "'. Check to ensure you have configured the client secret.", JWT_CLIENT_AUTHENTICATION_ERROR_URI);
                throw new OAuth2AuthenticationException(oauth2Error);
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(clientSecret.getBytes(StandardCharsets.UTF_8), JCA_ALGORITHM_MAPPINGS.get(jwsAlgorithm));
            return NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm((MacAlgorithm)jwsAlgorithm).build();
        }
        OAuth2Error oauth2Error = new OAuth2Error("invalid_client", "Failed to find a Signature Verifier for Client: '" + registeredClient.getId() + "'. Check to ensure you have configured a valid JWS Algorithm: '" + jwsAlgorithm + "'.", JWT_CLIENT_AUTHENTICATION_ERROR_URI);
        throw new OAuth2AuthenticationException(oauth2Error);
    }

    private static Function<RegisteredClient, OAuth2TokenValidator<Jwt>> defaultJwtValidatorFactory() {
        return registeredClient -> {
            String clientId = registeredClient.getClientId();
            OAuth2TokenValidator[] oAuth2TokenValidatorArray = new OAuth2TokenValidator[5];
            oAuth2TokenValidatorArray[0] = new JwtClaimValidator("iss", clientId::equals);
            oAuth2TokenValidatorArray[1] = new JwtClaimValidator("sub", clientId::equals);
            oAuth2TokenValidatorArray[2] = new JwtClaimValidator("aud", JwtClientAssertionDecoderFactory.containsAudience());
            oAuth2TokenValidatorArray[3] = new JwtClaimValidator("exp", Objects::nonNull);
            oAuth2TokenValidatorArray[4] = new JwtTimestampValidator();
            return new DelegatingOAuth2TokenValidator(oAuth2TokenValidatorArray);
        };
    }

    private static Predicate<List<String>> containsAudience() {
        return audienceClaim -> {
            if (CollectionUtils.isEmpty((Collection)audienceClaim)) {
                return false;
            }
            List<String> audienceList = JwtClientAssertionDecoderFactory.getAudience();
            for (String audience : audienceClaim) {
                if (!audienceList.contains(audience)) continue;
                return true;
            }
            return false;
        };
    }

    private static List<String> getAudience() {
        AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
        if (!StringUtils.hasText((String)authorizationServerContext.getIssuer())) {
            return Collections.emptyList();
        }
        AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
        ArrayList<String> audience = new ArrayList<String>();
        audience.add(authorizationServerContext.getIssuer());
        audience.add(JwtClientAssertionDecoderFactory.asUrl(authorizationServerContext.getIssuer(), authorizationServerSettings.getTokenEndpoint()));
        audience.add(JwtClientAssertionDecoderFactory.asUrl(authorizationServerContext.getIssuer(), authorizationServerSettings.getTokenIntrospectionEndpoint()));
        audience.add(JwtClientAssertionDecoderFactory.asUrl(authorizationServerContext.getIssuer(), authorizationServerSettings.getTokenRevocationEndpoint()));
        return audience;
    }

    private static String asUrl(String issuer, String endpoint) {
        return UriComponentsBuilder.fromUriString((String)issuer).path(endpoint).build().toUriString();
    }

    static {
        HashMap<MacAlgorithm, String> mappings = new HashMap<MacAlgorithm, String>();
        mappings.put(MacAlgorithm.HS256, "HmacSHA256");
        mappings.put(MacAlgorithm.HS384, "HmacSHA384");
        mappings.put(MacAlgorithm.HS512, "HmacSHA512");
        JCA_ALGORITHM_MAPPINGS = Collections.unmodifiableMap(mappings);
        restTemplate = new RestTemplate();
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(15000);
        requestFactory.setReadTimeout(15000);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
    }
}

