/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.util.SpringAuthorizationServerVersion;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OAuth2Authorization
implements Serializable {
    private static final long serialVersionUID = SpringAuthorizationServerVersion.SERIAL_VERSION_UID;
    private String id;
    private String registeredClientId;
    private String principalName;
    private AuthorizationGrantType authorizationGrantType;
    private Set<String> authorizedScopes;
    private Map<Class<? extends OAuth2Token>, Token<?>> tokens;
    private Map<String, Object> attributes;

    protected OAuth2Authorization() {
    }

    public String getId() {
        return this.id;
    }

    public String getRegisteredClientId() {
        return this.registeredClientId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public AuthorizationGrantType getAuthorizationGrantType() {
        return this.authorizationGrantType;
    }

    public Set<String> getAuthorizedScopes() {
        return this.authorizedScopes;
    }

    public Token<OAuth2AccessToken> getAccessToken() {
        return this.getToken(OAuth2AccessToken.class);
    }

    @Nullable
    public Token<OAuth2RefreshToken> getRefreshToken() {
        return this.getToken(OAuth2RefreshToken.class);
    }

    @Nullable
    public <T extends OAuth2Token> Token<T> getToken(Class<T> tokenType) {
        Assert.notNull(tokenType, (String)"tokenType cannot be null");
        Token<?> token = this.tokens.get(tokenType);
        return token != null ? token : null;
    }

    @Nullable
    public <T extends OAuth2Token> Token<T> getToken(String tokenValue) {
        Assert.hasText((String)tokenValue, (String)"tokenValue cannot be empty");
        for (Token<?> token : this.tokens.values()) {
            if (!token.getToken().getTokenValue().equals(tokenValue)) continue;
            return token;
        }
        return null;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public <T> T getAttribute(String name) {
        Assert.hasText((String)name, (String)"name cannot be empty");
        return (T)this.attributes.get(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2Authorization that = (OAuth2Authorization)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.registeredClientId, that.registeredClientId) && Objects.equals(this.principalName, that.principalName) && Objects.equals(this.authorizationGrantType, that.authorizationGrantType) && Objects.equals(this.authorizedScopes, that.authorizedScopes) && Objects.equals(this.tokens, that.tokens) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.registeredClientId, this.principalName, this.authorizationGrantType, this.authorizedScopes, this.tokens, this.attributes);
    }

    public static Builder withRegisteredClient(RegisteredClient registeredClient) {
        Assert.notNull((Object)registeredClient, (String)"registeredClient cannot be null");
        return new Builder(registeredClient.getId());
    }

    public static Builder from(OAuth2Authorization authorization) {
        Assert.notNull((Object)authorization, (String)"authorization cannot be null");
        return new Builder(authorization.getRegisteredClientId()).id(authorization.getId()).principalName(authorization.getPrincipalName()).authorizationGrantType(authorization.getAuthorizationGrantType()).authorizedScopes(authorization.getAuthorizedScopes()).tokens(authorization.tokens).attributes(attrs -> attrs.putAll(authorization.getAttributes()));
    }

    public static class Token<T extends OAuth2Token>
    implements Serializable {
        private static final long serialVersionUID = SpringAuthorizationServerVersion.SERIAL_VERSION_UID;
        protected static final String TOKEN_METADATA_NAMESPACE = "metadata.token.";
        public static final String INVALIDATED_METADATA_NAME = "metadata.token.".concat("invalidated");
        public static final String CLAIMS_METADATA_NAME = "metadata.token.".concat("claims");
        private final T token;
        private final Map<String, Object> metadata;

        protected Token(T token) {
            this(token, Token.defaultMetadata());
        }

        protected Token(T token, Map<String, Object> metadata) {
            this.token = token;
            this.metadata = Collections.unmodifiableMap(metadata);
        }

        public T getToken() {
            return this.token;
        }

        public boolean isInvalidated() {
            return Boolean.TRUE.equals(this.getMetadata(INVALIDATED_METADATA_NAME));
        }

        public boolean isExpired() {
            return this.getToken().getExpiresAt() != null && Instant.now().isAfter(this.getToken().getExpiresAt());
        }

        public boolean isBeforeUse() {
            Instant notBefore = null;
            if (!CollectionUtils.isEmpty(this.getClaims())) {
                notBefore = (Instant)this.getClaims().get("nbf");
            }
            return notBefore != null && Instant.now().isBefore(notBefore);
        }

        public boolean isActive() {
            return !this.isInvalidated() && !this.isExpired() && !this.isBeforeUse();
        }

        @Nullable
        public Map<String, Object> getClaims() {
            return (Map)this.getMetadata(CLAIMS_METADATA_NAME);
        }

        @Nullable
        public <V> V getMetadata(String name) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            return (V)this.metadata.get(name);
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        protected static Map<String, Object> defaultMetadata() {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put(INVALIDATED_METADATA_NAME, false);
            return metadata;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Token that = (Token)obj;
            return Objects.equals(this.token, that.token) && Objects.equals(this.metadata, that.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.token, this.metadata);
        }
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = SpringAuthorizationServerVersion.SERIAL_VERSION_UID;
        private String id;
        private final String registeredClientId;
        private String principalName;
        private AuthorizationGrantType authorizationGrantType;
        private Set<String> authorizedScopes;
        private Map<Class<? extends OAuth2Token>, Token<?>> tokens = new HashMap();
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        protected Builder(String registeredClientId) {
            this.registeredClientId = registeredClientId;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder principalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public Builder authorizationGrantType(AuthorizationGrantType authorizationGrantType) {
            this.authorizationGrantType = authorizationGrantType;
            return this;
        }

        public Builder authorizedScopes(Set<String> authorizedScopes) {
            this.authorizedScopes = authorizedScopes;
            return this;
        }

        public Builder accessToken(OAuth2AccessToken accessToken) {
            return this.token(accessToken);
        }

        public Builder refreshToken(OAuth2RefreshToken refreshToken) {
            return this.token(refreshToken);
        }

        public <T extends OAuth2Token> Builder token(T token) {
            return this.token(token, metadata -> {});
        }

        public <T extends OAuth2Token> Builder token(T token, Consumer<Map<String, Object>> metadataConsumer) {
            Assert.notNull(token, (String)"token cannot be null");
            Map<String, Object> metadata = Token.defaultMetadata();
            Token<?> existingToken = this.tokens.get(token.getClass());
            if (existingToken != null) {
                metadata.putAll(existingToken.getMetadata());
            }
            metadataConsumer.accept(metadata);
            Class<?> tokenClass = token.getClass();
            this.tokens.put(tokenClass, new Token<T>(token, metadata));
            return this;
        }

        public <T extends OAuth2Token> Builder invalidate(T token) {
            Assert.notNull(token, (String)"token cannot be null");
            if (this.tokens.get(token.getClass()) == null) {
                return this;
            }
            this.token(token, metadata -> metadata.put(Token.INVALIDATED_METADATA_NAME, true));
            if (OAuth2RefreshToken.class.isAssignableFrom(token.getClass())) {
                Token<?> accessToken = this.tokens.get(OAuth2AccessToken.class);
                this.token((T)accessToken.getToken(), metadata -> metadata.put(Token.INVALIDATED_METADATA_NAME, true));
                Token<?> authorizationCode = this.tokens.get(OAuth2AuthorizationCode.class);
                if (authorizationCode != null && !authorizationCode.isInvalidated()) {
                    this.token((T)authorizationCode.getToken(), metadata -> metadata.put(Token.INVALIDATED_METADATA_NAME, true));
                }
            }
            return this;
        }

        protected final Builder tokens(Map<Class<? extends OAuth2Token>, Token<?>> tokens) {
            this.tokens = new HashMap(tokens);
            return this;
        }

        public Builder attribute(String name, Object value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.attributes.put(name, value);
            return this;
        }

        public Builder attributes(Consumer<Map<String, Object>> attributesConsumer) {
            attributesConsumer.accept(this.attributes);
            return this;
        }

        public OAuth2Authorization build() {
            Assert.hasText((String)this.principalName, (String)"principalName cannot be empty");
            Assert.notNull((Object)this.authorizationGrantType, (String)"authorizationGrantType cannot be null");
            OAuth2Authorization authorization = new OAuth2Authorization();
            if (!StringUtils.hasText((String)this.id)) {
                this.id = UUID.randomUUID().toString();
            }
            authorization.id = this.id;
            authorization.registeredClientId = this.registeredClientId;
            authorization.principalName = this.principalName;
            authorization.authorizationGrantType = this.authorizationGrantType;
            authorization.authorizedScopes = Collections.unmodifiableSet(!CollectionUtils.isEmpty(this.authorizedScopes) ? new HashSet<String>(this.authorizedScopes) : new HashSet());
            authorization.tokens = Collections.unmodifiableMap(this.tokens);
            authorization.attributes = Collections.unmodifiableMap(this.attributes);
            return authorization;
        }
    }
}

