/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.DPoPProofVerifier;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationProviderUtils;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenExchangeActor;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenExchangeAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenExchangeCompositeAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.token.DefaultOAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class OAuth2TokenExchangeAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";
    private static final String JWT_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:jwt";
    private static final String ACCESS_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String MAY_ACT = "may_act";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator;

    public OAuth2TokenExchangeAuthenticationProvider(OAuth2AuthorizationService authorizationService, OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.notNull(tokenGenerator, (String)"tokenGenerator cannot be null");
        this.authorizationService = authorizationService;
        this.tokenGenerator = tokenGenerator;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        DefaultOAuth2TokenContext tokenContext;
        OAuth2Token generatedAccessToken;
        Object object;
        OAuth2Authorization.Token<OAuth2Token> subjectToken;
        OAuth2TokenExchangeAuthenticationToken tokenExchangeAuthentication = (OAuth2TokenExchangeAuthenticationToken)authentication;
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2AuthenticationProviderUtils.getAuthenticatedClientElseThrowInvalidClient((Authentication)tokenExchangeAuthentication);
        RegisteredClient registeredClient = clientPrincipal.getRegisteredClient();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved registered client");
        }
        if (!registeredClient.getAuthorizationGrantTypes().contains(AuthorizationGrantType.TOKEN_EXCHANGE)) {
            throw new OAuth2AuthenticationException("unauthorized_client");
        }
        if (JWT_TOKEN_TYPE_VALUE.equals(tokenExchangeAuthentication.getRequestedTokenType()) && !OAuth2TokenFormat.SELF_CONTAINED.equals(registeredClient.getTokenSettings().getAccessTokenFormat())) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        OAuth2Authorization subjectAuthorization = this.authorizationService.findByToken(tokenExchangeAuthentication.getSubjectToken(), OAuth2TokenType.ACCESS_TOKEN);
        if (subjectAuthorization == null) {
            throw new OAuth2AuthenticationException("invalid_grant");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved authorization with subject token");
        }
        if (!(subjectToken = subjectAuthorization.getToken(tokenExchangeAuthentication.getSubjectToken())).isActive()) {
            throw new OAuth2AuthenticationException("invalid_grant");
        }
        if (!OAuth2TokenExchangeAuthenticationProvider.isValidTokenType(tokenExchangeAuthentication.getSubjectTokenType(), subjectToken)) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        if (subjectAuthorization.getAttribute(Principal.class.getName()) == null) {
            throw new OAuth2AuthenticationException("invalid_grant");
        }
        Map authorizedActorClaims = null;
        if (subjectToken.getClaims() != null && subjectToken.getClaims().containsKey(MAY_ACT) && (object = subjectToken.getClaims().get(MAY_ACT)) instanceof Map) {
            Map mayAct;
            authorizedActorClaims = mayAct = (Map)object;
        }
        OAuth2Authorization actorAuthorization = null;
        if (StringUtils.hasText((String)tokenExchangeAuthentication.getActorToken())) {
            OAuth2Authorization.Token<OAuth2Token> actorToken;
            actorAuthorization = this.authorizationService.findByToken(tokenExchangeAuthentication.getActorToken(), OAuth2TokenType.ACCESS_TOKEN);
            if (actorAuthorization == null) {
                throw new OAuth2AuthenticationException("invalid_grant");
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Retrieved authorization with actor token");
            }
            if (!(actorToken = actorAuthorization.getToken(tokenExchangeAuthentication.getActorToken())).isActive()) {
                throw new OAuth2AuthenticationException("invalid_grant");
            }
            if (!OAuth2TokenExchangeAuthenticationProvider.isValidTokenType(tokenExchangeAuthentication.getActorTokenType(), actorToken)) {
                throw new OAuth2AuthenticationException("invalid_request");
            }
            if (authorizedActorClaims != null) {
                OAuth2TokenExchangeAuthenticationProvider.validateClaims(authorizedActorClaims, actorToken.getClaims(), "iss", "sub");
            }
        } else if (authorizedActorClaims != null) {
            throw new OAuth2AuthenticationException("invalid_grant");
        }
        Set<String> authorizedScopes = Collections.emptySet();
        if (!CollectionUtils.isEmpty(tokenExchangeAuthentication.getScopes())) {
            authorizedScopes = OAuth2TokenExchangeAuthenticationProvider.validateRequestedScopes(registeredClient, tokenExchangeAuthentication.getScopes());
        } else if (!CollectionUtils.isEmpty(subjectAuthorization.getAuthorizedScopes())) {
            authorizedScopes = OAuth2TokenExchangeAuthenticationProvider.validateRequestedScopes(registeredClient, subjectAuthorization.getAuthorizedScopes());
        }
        Jwt dPoPProof = DPoPProofVerifier.verifyIfAvailable(tokenExchangeAuthentication);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated token request parameters");
        }
        Authentication principal = OAuth2TokenExchangeAuthenticationProvider.getPrincipal(subjectAuthorization, actorAuthorization);
        DefaultOAuth2TokenContext.Builder tokenContextBuilder = (DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)DefaultOAuth2TokenContext.builder().registeredClient(registeredClient)).authorization(subjectAuthorization)).principal(principal)).authorizationServerContext(AuthorizationServerContextHolder.getContext())).authorizedScopes(authorizedScopes)).tokenType(OAuth2TokenType.ACCESS_TOKEN)).authorizationGrantType(AuthorizationGrantType.TOKEN_EXCHANGE)).authorizationGrant((Authentication)tokenExchangeAuthentication);
        if (dPoPProof != null) {
            tokenContextBuilder.put(OAuth2TokenContext.DPOP_PROOF_KEY, dPoPProof);
        }
        if ((generatedAccessToken = this.tokenGenerator.generate(tokenContext = tokenContextBuilder.build())) == null) {
            OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the access token.", ERROR_URI);
            throw new OAuth2AuthenticationException(error);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Generated access token");
        }
        OAuth2Authorization.Builder authorizationBuilder = OAuth2Authorization.withRegisteredClient(registeredClient).principalName(subjectAuthorization.getPrincipalName()).authorizationGrantType(AuthorizationGrantType.TOKEN_EXCHANGE).authorizedScopes(authorizedScopes).attribute(Principal.class.getName(), principal);
        OAuth2AccessToken accessToken = OAuth2AuthenticationProviderUtils.accessToken(authorizationBuilder, generatedAccessToken, tokenContext);
        OAuth2Authorization authorization = authorizationBuilder.build();
        this.authorizationService.save(authorization);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved authorization");
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        additionalParameters.put("issued_token_type", tokenExchangeAuthentication.getRequestedTokenType());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated token request");
        }
        return new OAuth2AccessTokenAuthenticationToken(registeredClient, (Authentication)clientPrincipal, accessToken, null, additionalParameters);
    }

    private static boolean isValidTokenType(String tokenType, OAuth2Authorization.Token<OAuth2Token> token) {
        String tokenFormat = (String)token.getMetadata(OAuth2TokenFormat.class.getName());
        return ACCESS_TOKEN_TYPE_VALUE.equals(tokenType) || JWT_TOKEN_TYPE_VALUE.equals(tokenType) && OAuth2TokenFormat.SELF_CONTAINED.getValue().equals(tokenFormat);
    }

    private static Set<String> validateRequestedScopes(RegisteredClient registeredClient, Set<String> requestedScopes) {
        for (String requestedScope : requestedScopes) {
            if (registeredClient.getScopes().contains(requestedScope)) continue;
            throw new OAuth2AuthenticationException("invalid_scope");
        }
        return new LinkedHashSet<String>(requestedScopes);
    }

    private static void validateClaims(Map<String, Object> expectedClaims, Map<String, Object> actualClaims, String ... claimNames) {
        if (actualClaims == null) {
            throw new OAuth2AuthenticationException("invalid_grant");
        }
        for (String claimName : claimNames) {
            if (Objects.equals(expectedClaims.get(claimName), actualClaims.get(claimName))) continue;
            throw new OAuth2AuthenticationException("invalid_grant");
        }
    }

    private static Authentication getPrincipal(OAuth2Authorization subjectAuthorization, OAuth2Authorization actorAuthorization) {
        Authentication subjectPrincipal = (Authentication)subjectAuthorization.getAttribute(Principal.class.getName());
        if (actorAuthorization == null) {
            if (subjectPrincipal instanceof OAuth2TokenExchangeCompositeAuthenticationToken) {
                OAuth2TokenExchangeCompositeAuthenticationToken compositeAuthenticationToken = (OAuth2TokenExchangeCompositeAuthenticationToken)subjectPrincipal;
                return compositeAuthenticationToken.getSubject();
            }
            return subjectPrincipal;
        }
        OAuth2TokenExchangeActor currentActor = new OAuth2TokenExchangeActor(actorAuthorization.getAccessToken().getClaims());
        LinkedList<OAuth2TokenExchangeActor> actorPrincipals = new LinkedList<OAuth2TokenExchangeActor>();
        actorPrincipals.add(currentActor);
        if (subjectPrincipal instanceof OAuth2TokenExchangeCompositeAuthenticationToken) {
            OAuth2TokenExchangeCompositeAuthenticationToken compositeAuthenticationToken = (OAuth2TokenExchangeCompositeAuthenticationToken)subjectPrincipal;
            subjectPrincipal = compositeAuthenticationToken.getSubject();
            actorPrincipals.addAll(compositeAuthenticationToken.getActors());
        }
        return new OAuth2TokenExchangeCompositeAuthenticationToken(subjectPrincipal, actorPrincipals);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2TokenExchangeAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

