/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2PushedAuthorizationRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContext;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OAuth2AuthorizationCodeRequestAuthenticationConverter
implements AuthenticationConverter {
    private static final String DEFAULT_ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2.1";
    private static final String PKCE_ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc7636#section-4.4.1";
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    private final RequestMatcher requestMatcher = OAuth2AuthorizationCodeRequestAuthenticationConverter.createDefaultRequestMatcher();

    public Authentication convert(HttpServletRequest request) {
        String prompt;
        String codeChallengeMethod;
        String codeChallenge;
        String state;
        String redirectUri;
        Authentication principal;
        if (!this.requestMatcher.matches(request)) {
            return null;
        }
        MultiValueMap<String, String> parameters = "GET".equals(request.getMethod()) ? OAuth2EndpointUtils.getQueryParameters(request) : OAuth2EndpointUtils.getFormParameters(request);
        boolean pushedAuthorizationRequest = this.isPushedAuthorizationRequest(request);
        String requestUri = (String)parameters.getFirst((Object)"request_uri");
        if (StringUtils.hasText((String)requestUri)) {
            if (pushedAuthorizationRequest) {
                OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "request_uri");
            } else if (((List)parameters.get((Object)"request_uri")).size() != 1) {
                OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "request_uri");
            }
        }
        if (!StringUtils.hasText((String)requestUri)) {
            String responseType = (String)parameters.getFirst((Object)"response_type");
            if (!StringUtils.hasText((String)responseType) || ((List)parameters.get((Object)"response_type")).size() != 1) {
                OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "response_type");
            } else if (!responseType.equals(OAuth2AuthorizationResponseType.CODE.getValue())) {
                OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("unsupported_response_type", "response_type");
            }
        }
        String authorizationUri = request.getRequestURL().toString();
        String clientId = (String)parameters.getFirst((Object)"client_id");
        if (!StringUtils.hasText((String)clientId) || ((List)parameters.get((Object)"client_id")).size() != 1) {
            OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "client_id");
        }
        if ((principal = SecurityContextHolder.getContext().getAuthentication()) == null) {
            principal = ANONYMOUS_AUTHENTICATION;
        }
        if (StringUtils.hasText((String)(redirectUri = (String)parameters.getFirst((Object)"redirect_uri"))) && ((List)parameters.get((Object)"redirect_uri")).size() != 1) {
            OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "redirect_uri");
        }
        HashSet<String> scopes = null;
        String scope = (String)parameters.getFirst((Object)"scope");
        if (StringUtils.hasText((String)scope) && ((List)parameters.get((Object)"scope")).size() != 1) {
            OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "scope");
        }
        if (StringUtils.hasText((String)scope)) {
            scopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        if (StringUtils.hasText((String)(state = (String)parameters.getFirst((Object)"state"))) && ((List)parameters.get((Object)"state")).size() != 1) {
            OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "state");
        }
        if (StringUtils.hasText((String)(codeChallenge = (String)parameters.getFirst((Object)"code_challenge"))) && ((List)parameters.get((Object)"code_challenge")).size() != 1) {
            OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "code_challenge", PKCE_ERROR_URI);
        }
        if (StringUtils.hasText((String)(codeChallengeMethod = (String)parameters.getFirst((Object)"code_challenge_method"))) && ((List)parameters.get((Object)"code_challenge_method")).size() != 1) {
            OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "code_challenge_method", PKCE_ERROR_URI);
        }
        if (!CollectionUtils.isEmpty(scopes) && scopes.contains("openid") && StringUtils.hasText((String)(prompt = (String)parameters.getFirst((Object)"prompt"))) && ((List)parameters.get((Object)"prompt")).size() != 1) {
            OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError("invalid_request", "prompt");
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!(key.equals("response_type") || key.equals("client_id") || key.equals("redirect_uri") || key.equals("scope") || key.equals("state"))) {
                additionalParameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0]));
            }
        });
        if (pushedAuthorizationRequest) {
            return new OAuth2PushedAuthorizationRequestAuthenticationToken(authorizationUri, clientId, principal, redirectUri, state, scopes, additionalParameters);
        }
        return new OAuth2AuthorizationCodeRequestAuthenticationToken(authorizationUri, clientId, principal, redirectUri, state, scopes, additionalParameters);
    }

    private boolean isPushedAuthorizationRequest(HttpServletRequest request) {
        AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
        AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
        return request.getRequestURL().toString().toLowerCase(Locale.ROOT).endsWith(authorizationServerSettings.getPushedAuthorizationRequestEndpoint().toLowerCase(Locale.ROOT));
    }

    private static RequestMatcher createDefaultRequestMatcher() {
        RequestMatcher getMethodMatcher = request -> "GET".equals(request.getMethod());
        RequestMatcher postMethodMatcher = request -> "POST".equals(request.getMethod());
        RequestMatcher responseTypeParameterMatcher = request -> request.getParameter("response_type") != null;
        return new OrRequestMatcher(new RequestMatcher[]{getMethodMatcher, new AndRequestMatcher(new RequestMatcher[]{postMethodMatcher, responseTypeParameterMatcher})});
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2AuthorizationCodeRequestAuthenticationConverter.throwError(errorCode, parameterName, DEFAULT_ERROR_URI);
    }

    private static void throwError(String errorCode, String parameterName, String errorUri) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, errorUri);
        throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, null);
    }
}

