/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceCodeAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OAuth2DeviceCodeAuthenticationConverter
implements AuthenticationConverter {
    @Nullable
    public Authentication convert(HttpServletRequest request) {
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getFormParameters(request);
        String grantType = (String)parameters.getFirst((Object)"grant_type");
        if (!AuthorizationGrantType.DEVICE_CODE.getValue().equals(grantType)) {
            return null;
        }
        Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
        String deviceCode = (String)parameters.getFirst((Object)"device_code");
        if (!StringUtils.hasText((String)deviceCode) || ((List)parameters.get((Object)"device_code")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "device_code", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!(key.equals("grant_type") || key.equals("client_id") || key.equals("device_code"))) {
                additionalParameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0]));
            }
        });
        OAuth2EndpointUtils.validateAndAddDPoPParametersIfAvailable(request, additionalParameters);
        return new OAuth2DeviceCodeAuthenticationToken(deviceCode, clientPrincipal, additionalParameters);
    }
}

