/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Set;
import java.util.function.Consumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.web.reactive.function.OAuth2BodyExtractors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class WebClientReactiveClientCredentialsTokenResponseClient
implements ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> {
    private WebClient webClient = WebClient.builder().build();

    @Override
    public Mono<OAuth2AccessTokenResponse> getTokenResponse(OAuth2ClientCredentialsGrantRequest authorizationGrantRequest) {
        return Mono.defer(() -> {
            ClientRegistration clientRegistration = authorizationGrantRequest.getClientRegistration();
            String tokenUri = clientRegistration.getProviderDetails().getTokenUri();
            BodyInserters.FormInserter<String> body = WebClientReactiveClientCredentialsTokenResponseClient.body(authorizationGrantRequest);
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(tokenUri, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).headers(this.headers(clientRegistration))).body(body).exchange().flatMap(response -> (Mono)response.body(OAuth2BodyExtractors.oauth2AccessTokenResponse())).map(response -> {
                if (response.getAccessToken().getScopes().isEmpty()) {
                    response = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)response).scopes(authorizationGrantRequest.getClientRegistration().getScopes()).build();
                }
                return response;
            });
        });
    }

    private Consumer<HttpHeaders> headers(ClientRegistration clientRegistration) {
        return headers -> {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            headers.setBasicAuth(clientRegistration.getClientId(), clientRegistration.getClientSecret());
            if (ClientAuthenticationMethod.BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
                headers.setBasicAuth(clientRegistration.getClientId(), clientRegistration.getClientSecret());
            }
        };
    }

    private static BodyInserters.FormInserter<String> body(OAuth2ClientCredentialsGrantRequest authorizationGrantRequest) {
        ClientRegistration clientRegistration = authorizationGrantRequest.getClientRegistration();
        BodyInserters.FormInserter body = BodyInserters.fromFormData((String)"grant_type", (String)authorizationGrantRequest.getGrantType().getValue());
        Set<String> scopes = clientRegistration.getScopes();
        if (!CollectionUtils.isEmpty(scopes)) {
            String scope = StringUtils.collectionToDelimitedString(scopes, (String)" ");
            body.with("scope", (Object)scope);
        }
        if (ClientAuthenticationMethod.POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            body.with("client_id", (Object)clientRegistration.getClientId());
            body.with("client_secret", (Object)clientRegistration.getClientSecret());
        }
        return body;
    }
}

