/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.result.method.annotation;

import java.lang.reflect.AnnotatedElement;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.security.oauth2.client.annotation.RegisteredOAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.result.method.annotation.OAuth2AuthorizedClientResolver;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class OAuth2AuthorizedClientArgumentResolver
implements HandlerMethodArgumentResolver {
    private final OAuth2AuthorizedClientResolver authorizedClientResolver;

    public OAuth2AuthorizedClientArgumentResolver(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.authorizedClientResolver = new OAuth2AuthorizedClientResolver(clientRegistrationRepository, authorizedClientRepository);
        this.authorizedClientResolver.setDefaultOAuth2AuthorizedClient(true);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), RegisteredOAuth2AuthorizedClient.class) != null;
    }

    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        return Mono.defer(() -> {
            RegisteredOAuth2AuthorizedClient authorizedClientAnnotation = (RegisteredOAuth2AuthorizedClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), RegisteredOAuth2AuthorizedClient.class);
            String clientRegistrationId = StringUtils.hasLength((String)authorizedClientAnnotation.registrationId()) ? authorizedClientAnnotation.registrationId() : null;
            return this.authorizedClientResolver.createDefaultedRequest(clientRegistrationId, null, exchange).flatMap(this.authorizedClientResolver::loadAuthorizedClient);
        });
    }
}

