/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Collections;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.MultiValueMap;

final class OAuth2AuthorizationGrantRequestEntityUtils {
    private static HttpHeaders DEFAULT_TOKEN_REQUEST_HEADERS = OAuth2AuthorizationGrantRequestEntityUtils.getDefaultTokenRequestHeaders();

    OAuth2AuthorizationGrantRequestEntityUtils() {
    }

    static HttpHeaders getTokenRequestHeaders(ClientRegistration clientRegistration) {
        HttpHeaders headers = new HttpHeaders();
        headers.addAll((MultiValueMap)DEFAULT_TOKEN_REQUEST_HEADERS);
        if (ClientAuthenticationMethod.BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            headers.setBasicAuth(clientRegistration.getClientId(), clientRegistration.getClientSecret());
        }
        return headers;
    }

    private static HttpHeaders getDefaultTokenRequestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON_UTF8));
        MediaType contentType = MediaType.valueOf((String)"application/x-www-form-urlencoded;charset=UTF-8");
        headers.setContentType(contentType);
        return headers;
    }
}

