/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.function.client;

import java.util.Collection;
import java.util.Optional;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.ClientAuthorizationRequiredException;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class OAuth2AuthorizedClientResolver {
    private static final AnonymousAuthenticationToken ANONYMOUS_USER_TOKEN = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private final ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
    private ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient = new WebClientReactiveClientCredentialsTokenResponseClient();
    private boolean defaultOAuth2AuthorizedClient;
    private String defaultClientRegistrationId;

    public OAuth2AuthorizedClientResolver(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientRepository = authorizedClientRepository;
    }

    public void setDefaultOAuth2AuthorizedClient(boolean defaultOAuth2AuthorizedClient) {
        this.defaultOAuth2AuthorizedClient = defaultOAuth2AuthorizedClient;
    }

    public void setDefaultClientRegistrationId(String clientRegistrationId) {
        this.defaultClientRegistrationId = clientRegistrationId;
    }

    public void setClientCredentialsTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient) {
        Assert.notNull(clientCredentialsTokenResponseClient, (String)"clientCredentialsTokenResponseClient cannot be null");
        this.clientCredentialsTokenResponseClient = clientCredentialsTokenResponseClient;
    }

    Mono<Request> createDefaultedRequest(String clientRegistrationId, Authentication authentication, ServerWebExchange exchange) {
        Mono defaultedAuthentication = Mono.justOrEmpty((Object)authentication).switchIfEmpty(this.currentAuthentication());
        Mono defaultedRegistrationId = Mono.justOrEmpty((Object)clientRegistrationId).switchIfEmpty(Mono.justOrEmpty((Object)this.defaultClientRegistrationId)).switchIfEmpty(this.clientRegistrationId((Mono<Authentication>)defaultedAuthentication));
        Mono defaultedExchange = Mono.justOrEmpty((Object)exchange).switchIfEmpty(this.currentServerWebExchange()).map(Optional::of).defaultIfEmpty(Optional.empty());
        return Mono.zip((Mono)defaultedRegistrationId, (Mono)defaultedAuthentication, (Mono)defaultedExchange).map(t3 -> new Request((String)t3.getT1(), (Authentication)t3.getT2(), ((Optional)t3.getT3()).orElse(null)));
    }

    Mono<OAuth2AuthorizedClient> loadAuthorizedClient(Request request) {
        String clientRegistrationId = request.getClientRegistrationId();
        Authentication authentication = request.getAuthentication();
        ServerWebExchange exchange = request.getExchange();
        return this.authorizedClientRepository.loadAuthorizedClient(clientRegistrationId, authentication, exchange).switchIfEmpty(this.authorizedClientNotLoaded(clientRegistrationId, authentication, exchange));
    }

    private Mono<OAuth2AuthorizedClient> authorizedClientNotLoaded(String clientRegistrationId, Authentication authentication, ServerWebExchange exchange) {
        return this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("Client Registration with id " + clientRegistrationId + " was not found"))).flatMap(clientRegistration -> {
            if (AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)clientRegistration.getAuthorizationGrantType())) {
                return this.clientCredentials((ClientRegistration)clientRegistration, authentication, exchange);
            }
            return Mono.error(() -> new ClientAuthorizationRequiredException(clientRegistrationId));
        });
    }

    private Mono<? extends OAuth2AuthorizedClient> clientCredentials(ClientRegistration clientRegistration, Authentication authentication, ServerWebExchange exchange) {
        OAuth2ClientCredentialsGrantRequest grantRequest = new OAuth2ClientCredentialsGrantRequest(clientRegistration);
        return this.clientCredentialsTokenResponseClient.getTokenResponse(grantRequest).flatMap(tokenResponse -> this.clientCredentialsResponse(clientRegistration, authentication, exchange, (OAuth2AccessTokenResponse)tokenResponse));
    }

    private Mono<OAuth2AuthorizedClient> clientCredentialsResponse(ClientRegistration clientRegistration, Authentication authentication, ServerWebExchange exchange, OAuth2AccessTokenResponse tokenResponse) {
        OAuth2AuthorizedClient authorizedClient = new OAuth2AuthorizedClient(clientRegistration, authentication.getName(), tokenResponse.getAccessToken());
        return this.authorizedClientRepository.saveAuthorizedClient(authorizedClient, authentication, exchange).thenReturn((Object)authorizedClient);
    }

    private Mono<String> clientRegistrationId(Mono<Authentication> authentication) {
        return authentication.filter(t -> this.defaultOAuth2AuthorizedClient && t instanceof OAuth2AuthenticationToken).cast(OAuth2AuthenticationToken.class).map(OAuth2AuthenticationToken::getAuthorizedClientRegistrationId);
    }

    private Mono<Authentication> currentAuthentication() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).defaultIfEmpty((Object)ANONYMOUS_USER_TOKEN);
    }

    private Mono<ServerWebExchange> currentServerWebExchange() {
        return Mono.subscriberContext().filter(c -> c.hasKey(ServerWebExchange.class)).map(c -> (ServerWebExchange)c.get(ServerWebExchange.class));
    }

    static class Request {
        private final String clientRegistrationId;
        private final Authentication authentication;
        private final ServerWebExchange exchange;

        public Request(String clientRegistrationId, Authentication authentication, ServerWebExchange exchange) {
            this.clientRegistrationId = clientRegistrationId;
            this.authentication = authentication;
            this.exchange = exchange;
        }

        public String getClientRegistrationId() {
            return this.clientRegistrationId;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public ServerWebExchange getExchange() {
            return this.exchange;
        }
    }
}

