/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.util.Base64;
import java.util.HashMap;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class DefaultServerOAuth2AuthorizationRequestResolver
implements ServerOAuth2AuthorizationRequestResolver {
    public static final String DEFAULT_REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    public static final String DEFAULT_AUTHORIZATION_REQUEST_PATTERN = "/oauth2/authorization/{registrationId}";
    private final ServerWebExchangeMatcher authorizationRequestMatcher;
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private final StringKeyGenerator stateGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder());

    public DefaultServerOAuth2AuthorizationRequestResolver(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        this(clientRegistrationRepository, (ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher(DEFAULT_AUTHORIZATION_REQUEST_PATTERN));
    }

    public DefaultServerOAuth2AuthorizationRequestResolver(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerWebExchangeMatcher authorizationRequestMatcher) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizationRequestMatcher, (String)"authorizationRequestMatcher cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizationRequestMatcher = authorizationRequestMatcher;
    }

    @Override
    public Mono<OAuth2AuthorizationRequest> resolve(ServerWebExchange exchange) {
        return this.authorizationRequestMatcher.matches(exchange).filter(matchResult -> matchResult.isMatch()).map(ServerWebExchangeMatcher.MatchResult::getVariables).map(variables -> variables.get(DEFAULT_REGISTRATION_ID_URI_VARIABLE_NAME)).cast(String.class).flatMap(clientRegistrationId -> this.resolve(exchange, (String)clientRegistrationId));
    }

    @Override
    public Mono<OAuth2AuthorizationRequest> resolve(ServerWebExchange exchange, String clientRegistrationId) {
        return this.findByRegistrationId(exchange, clientRegistrationId).map(clientRegistration -> this.authorizationRequest(exchange, (ClientRegistration)clientRegistration));
    }

    private Mono<ClientRegistration> findByRegistrationId(ServerWebExchange exchange, String clientRegistration) {
        return this.clientRegistrationRepository.findByRegistrationId(clientRegistration).switchIfEmpty(Mono.error(() -> new ResponseStatusException(HttpStatus.BAD_REQUEST, "Invalid client registration id")));
    }

    private OAuth2AuthorizationRequest authorizationRequest(ServerWebExchange exchange, ClientRegistration clientRegistration) {
        OAuth2AuthorizationRequest.Builder builder;
        String redirectUriStr = this.expandRedirectUri(exchange.getRequest(), clientRegistration);
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        additionalParameters.put("registration_id", clientRegistration.getRegistrationId());
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            builder = OAuth2AuthorizationRequest.authorizationCode();
        } else if (AuthorizationGrantType.IMPLICIT.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            builder = OAuth2AuthorizationRequest.implicit();
        } else {
            throw new IllegalArgumentException("Invalid Authorization Grant Type (" + clientRegistration.getAuthorizationGrantType().getValue() + ") for Client Registration with Id: " + clientRegistration.getRegistrationId());
        }
        return builder.clientId(clientRegistration.getClientId()).authorizationUri(clientRegistration.getProviderDetails().getAuthorizationUri()).redirectUri(redirectUriStr).scopes(clientRegistration.getScopes()).state(this.stateGenerator.generateKey()).additionalParameters(additionalParameters).build();
    }

    private String expandRedirectUri(ServerHttpRequest request, ClientRegistration clientRegistration) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put(DEFAULT_REGISTRATION_ID_URI_VARIABLE_NAME, clientRegistration.getRegistrationId());
        String baseUrl = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServerHttpRequestDecorator(request)).replacePath(request.getPath().contextPath().value()).replaceQuery(null).build().toUriString();
        uriVariables.put("baseUrl", baseUrl);
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            String loginAction = "login";
            uriVariables.put("action", loginAction);
        }
        return UriComponentsBuilder.fromUriString((String)clientRegistration.getRedirectUriTemplate()).buildAndExpand(uriVariables).toUriString();
    }
}

