/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.net.URI;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationGrantRequestEntityUtils;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2ClientCredentialsGrantRequestEntityConverter
implements Converter<OAuth2ClientCredentialsGrantRequest, RequestEntity<?>> {
    public RequestEntity<?> convert(OAuth2ClientCredentialsGrantRequest clientCredentialsGrantRequest) {
        ClientRegistration clientRegistration = clientCredentialsGrantRequest.getClientRegistration();
        HttpHeaders headers = OAuth2AuthorizationGrantRequestEntityUtils.getTokenRequestHeaders(clientRegistration);
        MultiValueMap<String, String> formParameters = this.buildFormParameters(clientCredentialsGrantRequest);
        URI uri = UriComponentsBuilder.fromUriString((String)clientRegistration.getProviderDetails().getTokenUri()).build().toUri();
        return new RequestEntity(formParameters, (MultiValueMap)headers, HttpMethod.POST, uri);
    }

    private MultiValueMap<String, String> buildFormParameters(OAuth2ClientCredentialsGrantRequest clientCredentialsGrantRequest) {
        ClientRegistration clientRegistration = clientCredentialsGrantRequest.getClientRegistration();
        LinkedMultiValueMap formParameters = new LinkedMultiValueMap();
        formParameters.add((Object)"grant_type", (Object)clientCredentialsGrantRequest.getGrantType().getValue());
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            formParameters.add((Object)"scope", (Object)StringUtils.collectionToDelimitedString(clientRegistration.getScopes(), (String)" "));
        }
        if (ClientAuthenticationMethod.POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            formParameters.add((Object)"client_id", (Object)clientRegistration.getClientId());
            formParameters.add((Object)"client_secret", (Object)clientRegistration.getClientSecret());
        }
        return formParameters;
    }
}

