/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2AuthorizeRequest {
    private String clientRegistrationId;
    private OAuth2AuthorizedClient authorizedClient;
    private Authentication principal;
    private Map<String, Object> attributes;

    private OAuth2AuthorizeRequest() {
    }

    public String getClientRegistrationId() {
        return this.clientRegistrationId;
    }

    @Nullable
    public OAuth2AuthorizedClient getAuthorizedClient() {
        return this.authorizedClient;
    }

    public Authentication getPrincipal() {
        return this.principal;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public <T> T getAttribute(String name) {
        return (T)this.getAttributes().get(name);
    }

    public static Builder withClientRegistrationId(String clientRegistrationId) {
        return new Builder(clientRegistrationId);
    }

    public static Builder withAuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
        return new Builder(authorizedClient);
    }

    public static class Builder {
        private String clientRegistrationId;
        private OAuth2AuthorizedClient authorizedClient;
        private Authentication principal;
        private Map<String, Object> attributes;

        private Builder(String clientRegistrationId) {
            Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
            this.clientRegistrationId = clientRegistrationId;
        }

        private Builder(OAuth2AuthorizedClient authorizedClient) {
            Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
            this.authorizedClient = authorizedClient;
        }

        public Builder principal(Authentication principal) {
            this.principal = principal;
            return this;
        }

        public Builder attributes(Consumer<Map<String, Object>> attributesConsumer) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            attributesConsumer.accept(this.attributes);
            return this;
        }

        public Builder attribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(name, value);
            return this;
        }

        public OAuth2AuthorizeRequest build() {
            Assert.notNull((Object)this.principal, (String)"principal cannot be null");
            OAuth2AuthorizeRequest authorizeRequest = new OAuth2AuthorizeRequest();
            if (this.authorizedClient != null) {
                authorizeRequest.clientRegistrationId = this.authorizedClient.getClientRegistration().getRegistrationId();
                authorizeRequest.authorizedClient = this.authorizedClient;
            } else {
                authorizeRequest.clientRegistrationId = this.clientRegistrationId;
            }
            authorizeRequest.principal = this.principal;
            authorizeRequest.attributes = Collections.unmodifiableMap(CollectionUtils.isEmpty(this.attributes) ? Collections.emptyMap() : new LinkedHashMap<String, Object>(this.attributes));
            return authorizeRequest;
        }
    }
}

