/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.function.client;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizationSuccessHandler;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.UnAuthenticatedServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class ServerOAuth2AuthorizedClientExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final String OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME = OAuth2AuthorizedClient.class.getName();
    private static final String CLIENT_REGISTRATION_ID_ATTR_NAME = OAuth2AuthorizedClient.class.getName().concat(".CLIENT_REGISTRATION_ID");
    private static final String SERVER_WEB_EXCHANGE_ATTR_NAME = ServerWebExchange.class.getName();
    private static final AnonymousAuthenticationToken ANONYMOUS_USER_TOKEN = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
    private final Mono<Authentication> currentAuthenticationMono = ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).defaultIfEmpty((Object)ANONYMOUS_USER_TOKEN);
    private final Mono<String> clientRegistrationIdMono = this.currentAuthenticationMono.filter(t -> this.defaultOAuth2AuthorizedClient && t instanceof OAuth2AuthenticationToken).cast(OAuth2AuthenticationToken.class).map(OAuth2AuthenticationToken::getAuthorizedClientRegistrationId);
    private final Mono<ServerWebExchange> currentServerWebExchangeMono = Mono.subscriberContext().filter(c -> c.hasKey(ServerWebExchange.class)).map(c -> (ServerWebExchange)c.get(ServerWebExchange.class));
    private final ReactiveOAuth2AuthorizedClientManager authorizedClientManager;
    private boolean defaultAuthorizedClientManager;
    private boolean defaultOAuth2AuthorizedClient;
    private String defaultClientRegistrationId;
    @Deprecated
    private Duration accessTokenExpiresSkew = Duration.ofMinutes(1L);
    @Deprecated
    private ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;
    private ClientResponseHandler clientResponseHandler;

    public ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveOAuth2AuthorizedClientManager authorizedClientManager) {
        Assert.notNull((Object)authorizedClientManager, (String)"authorizedClientManager cannot be null");
        this.authorizedClientManager = authorizedClientManager;
        this.clientResponseHandler = (request, responseMono) -> responseMono;
    }

    public ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler = new RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler((clientRegistrationId, principal, attributes) -> authorizedClientRepository.removeAuthorizedClient(clientRegistrationId, principal, (ServerWebExchange)attributes.get(ServerWebExchange.class.getName())));
        this.authorizedClientManager = ServerOAuth2AuthorizedClientExchangeFilterFunction.createDefaultAuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository, authorizationFailureHandler);
        this.clientResponseHandler = new AuthorizationFailureForwarder(authorizationFailureHandler);
        this.defaultAuthorizedClientManager = true;
    }

    private static ReactiveOAuth2AuthorizedClientManager createDefaultAuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository, ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().password().build();
        if (authorizedClientRepository instanceof UnAuthenticatedServerOAuth2AuthorizedClientRepository) {
            UnAuthenticatedReactiveOAuth2AuthorizedClientManager unauthenticatedAuthorizedClientManager = new UnAuthenticatedReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, (UnAuthenticatedServerOAuth2AuthorizedClientRepository)authorizedClientRepository, authorizationFailureHandler);
            unauthenticatedAuthorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
            return unauthenticatedAuthorizedClientManager;
        }
        DefaultReactiveOAuth2AuthorizedClientManager authorizedClientManager = new DefaultReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        authorizedClientManager.setAuthorizationFailureHandler(authorizationFailureHandler);
        return authorizedClientManager;
    }

    public static Consumer<Map<String, Object>> oauth2AuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
        return attributes -> attributes.put(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME, authorizedClient);
    }

    private static OAuth2AuthorizedClient oauth2AuthorizedClient(ClientRequest request) {
        return (OAuth2AuthorizedClient)request.attributes().get(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> serverWebExchange(ServerWebExchange serverWebExchange) {
        return attributes -> attributes.put(SERVER_WEB_EXCHANGE_ATTR_NAME, serverWebExchange);
    }

    private static ServerWebExchange serverWebExchange(ClientRequest request) {
        return (ServerWebExchange)request.attributes().get(SERVER_WEB_EXCHANGE_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> clientRegistrationId(String clientRegistrationId) {
        return attributes -> attributes.put(CLIENT_REGISTRATION_ID_ATTR_NAME, clientRegistrationId);
    }

    private static String clientRegistrationId(ClientRequest request) {
        OAuth2AuthorizedClient authorizedClient = ServerOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient(request);
        if (authorizedClient != null) {
            return authorizedClient.getClientRegistration().getRegistrationId();
        }
        return (String)request.attributes().get(CLIENT_REGISTRATION_ID_ATTR_NAME);
    }

    public void setDefaultOAuth2AuthorizedClient(boolean defaultOAuth2AuthorizedClient) {
        this.defaultOAuth2AuthorizedClient = defaultOAuth2AuthorizedClient;
    }

    public void setDefaultClientRegistrationId(String clientRegistrationId) {
        this.defaultClientRegistrationId = clientRegistrationId;
    }

    @Deprecated
    public void setClientCredentialsTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient) {
        Assert.notNull(clientCredentialsTokenResponseClient, (String)"clientCredentialsTokenResponseClient cannot be null");
        Assert.state((boolean)this.defaultAuthorizedClientManager, (String)"The client cannot be set when the constructor used is \"ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveOAuth2AuthorizedClientManager)\". Instead, use the constructor \"ServerOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository, OAuth2AuthorizedClientRepository)\".");
        this.clientCredentialsTokenResponseClient = clientCredentialsTokenResponseClient;
        this.updateDefaultAuthorizedClientManager();
    }

    private void updateDefaultAuthorizedClientManager() {
        ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken(configurer -> configurer.clockSkew(this.accessTokenExpiresSkew)).clientCredentials(this::updateClientCredentialsProvider).password(configurer -> configurer.clockSkew(this.accessTokenExpiresSkew)).build();
        if (this.authorizedClientManager instanceof UnAuthenticatedReactiveOAuth2AuthorizedClientManager) {
            ((UnAuthenticatedReactiveOAuth2AuthorizedClientManager)this.authorizedClientManager).setAuthorizedClientProvider(authorizedClientProvider);
        } else {
            ((DefaultReactiveOAuth2AuthorizedClientManager)this.authorizedClientManager).setAuthorizedClientProvider(authorizedClientProvider);
        }
    }

    private void updateClientCredentialsProvider(ReactiveOAuth2AuthorizedClientProviderBuilder.ClientCredentialsGrantBuilder builder) {
        if (this.clientCredentialsTokenResponseClient != null) {
            builder.accessTokenResponseClient(this.clientCredentialsTokenResponseClient);
        }
        builder.clockSkew(this.accessTokenExpiresSkew);
    }

    @Deprecated
    public void setAccessTokenExpiresSkew(Duration accessTokenExpiresSkew) {
        Assert.notNull((Object)accessTokenExpiresSkew, (String)"accessTokenExpiresSkew cannot be null");
        Assert.state((boolean)this.defaultAuthorizedClientManager, (String)"The accessTokenExpiresSkew cannot be set when the constructor used is \"ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveOAuth2AuthorizedClientManager)\". Instead, use the constructor \"ServerOAuth2AuthorizedClientExchangeFilterFunction(ClientRegistrationRepository, OAuth2AuthorizedClientRepository)\".");
        this.accessTokenExpiresSkew = accessTokenExpiresSkew;
        this.updateDefaultAuthorizedClientManager();
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return this.authorizedClient(request).map(authorizedClient -> this.bearer(request, (OAuth2AuthorizedClient)authorizedClient)).flatMap(requestWithBearer -> this.exchangeAndHandleResponse((ClientRequest)requestWithBearer, next)).switchIfEmpty(Mono.defer(() -> this.exchangeAndHandleResponse(request, next)));
    }

    private Mono<ClientResponse> exchangeAndHandleResponse(ClientRequest request, ExchangeFunction next) {
        return next.exchange(request).transform(responseMono -> this.clientResponseHandler.handleResponse(request, (Mono<ClientResponse>)responseMono));
    }

    private Mono<OAuth2AuthorizedClient> authorizedClient(ClientRequest request) {
        OAuth2AuthorizedClient authorizedClientFromAttrs = ServerOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient(request);
        return Mono.justOrEmpty((Object)authorizedClientFromAttrs).switchIfEmpty(Mono.defer(() -> this.authorizeRequest(request).flatMap(this.authorizedClientManager::authorize))).flatMap(authorizedClient -> this.reauthorizeRequest(request, (OAuth2AuthorizedClient)authorizedClient).flatMap(this.authorizedClientManager::authorize));
    }

    private Mono<OAuth2AuthorizeRequest> authorizeRequest(ClientRequest request) {
        Mono<String> clientRegistrationId = this.effectiveClientRegistrationId(request);
        Mono<Optional<ServerWebExchange>> serverWebExchange = this.effectiveServerWebExchange(request);
        return Mono.zip(clientRegistrationId, this.currentAuthenticationMono, serverWebExchange).map(t3 -> {
            OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withClientRegistrationId((String)t3.getT1()).principal((Authentication)t3.getT2());
            ((Optional)t3.getT3()).ifPresent(exchange -> builder.attribute(ServerWebExchange.class.getName(), exchange));
            return builder.build();
        });
    }

    private Mono<String> effectiveClientRegistrationId(ClientRequest request) {
        return Mono.justOrEmpty((Object)ServerOAuth2AuthorizedClientExchangeFilterFunction.clientRegistrationId(request)).switchIfEmpty(Mono.justOrEmpty((Object)this.defaultClientRegistrationId)).switchIfEmpty(this.clientRegistrationIdMono);
    }

    private Mono<Optional<ServerWebExchange>> effectiveServerWebExchange(ClientRequest request) {
        return Mono.justOrEmpty((Object)ServerOAuth2AuthorizedClientExchangeFilterFunction.serverWebExchange(request)).switchIfEmpty(this.currentServerWebExchangeMono).map(Optional::of).defaultIfEmpty(Optional.empty());
    }

    private Mono<OAuth2AuthorizeRequest> reauthorizeRequest(ClientRequest request, OAuth2AuthorizedClient authorizedClient) {
        Mono<Optional<ServerWebExchange>> serverWebExchange = this.effectiveServerWebExchange(request);
        return Mono.zip(this.currentAuthenticationMono, serverWebExchange).map(t2 -> {
            OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withAuthorizedClient(authorizedClient).principal((Authentication)t2.getT1());
            ((Optional)t2.getT2()).ifPresent(exchange -> builder.attribute(ServerWebExchange.class.getName(), exchange));
            return builder.build();
        });
    }

    private ClientRequest bearer(ClientRequest request, OAuth2AuthorizedClient authorizedClient) {
        return ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBearerAuth(authorizedClient.getAccessToken().getTokenValue())).build();
    }

    public void setAuthorizationFailureHandler(ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        Assert.notNull((Object)authorizationFailureHandler, (String)"authorizationFailureHandler cannot be null");
        this.clientResponseHandler = new AuthorizationFailureForwarder(authorizationFailureHandler);
    }

    private class AuthorizationFailureForwarder
    implements ClientResponseHandler {
        private final Map<Integer, String> httpStatusToOAuth2ErrorCodeMap;
        private final ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler;

        private AuthorizationFailureForwarder(ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler) {
            Assert.notNull((Object)authorizationFailureHandler, (String)"authorizationFailureHandler cannot be null");
            this.authorizationFailureHandler = authorizationFailureHandler;
            HashMap<Integer, String> httpStatusToOAuth2Error = new HashMap<Integer, String>();
            httpStatusToOAuth2Error.put(HttpStatus.UNAUTHORIZED.value(), "invalid_token");
            httpStatusToOAuth2Error.put(HttpStatus.FORBIDDEN.value(), "insufficient_scope");
            this.httpStatusToOAuth2ErrorCodeMap = Collections.unmodifiableMap(httpStatusToOAuth2Error);
        }

        @Override
        public Mono<ClientResponse> handleResponse(ClientRequest request, Mono<ClientResponse> responseMono) {
            return responseMono.flatMap(response -> this.handleResponse(request, (ClientResponse)response).thenReturn(response)).onErrorResume(WebClientResponseException.class, e -> this.handleWebClientResponseException(request, (WebClientResponseException)e).then(Mono.error((Throwable)e))).onErrorResume(OAuth2AuthorizationException.class, e -> this.handleAuthorizationException(request, (OAuth2AuthorizationException)((Object)e)).then(Mono.error((Throwable)e)));
        }

        private Mono<Void> handleResponse(ClientRequest request, ClientResponse response) {
            return Mono.justOrEmpty((Object)this.resolveErrorIfPossible(response)).flatMap(oauth2Error -> {
                Mono serverWebExchange = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveServerWebExchange(request);
                Mono clientRegistrationId = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveClientRegistrationId(request);
                return Mono.zip((Mono)ServerOAuth2AuthorizedClientExchangeFilterFunction.this.currentAuthenticationMono, (Mono)serverWebExchange, (Mono)clientRegistrationId).flatMap(tuple3 -> this.handleAuthorizationFailure((Authentication)tuple3.getT1(), ((Optional)tuple3.getT2()).orElse(null), new ClientAuthorizationException((OAuth2Error)oauth2Error, (String)tuple3.getT3())));
            });
        }

        private OAuth2Error resolveErrorIfPossible(ClientResponse response) {
            String wwwAuthenticateHeader;
            Map<String, String> authParameters;
            if (!response.headers().header("WWW-Authenticate").isEmpty() && (authParameters = this.parseAuthParameters(wwwAuthenticateHeader = (String)response.headers().header("WWW-Authenticate").get(0))).containsKey("error")) {
                return new OAuth2Error(authParameters.get("error"), authParameters.get("error_description"), authParameters.get("error_uri"));
            }
            return this.resolveErrorIfPossible(response.rawStatusCode());
        }

        private OAuth2Error resolveErrorIfPossible(int statusCode) {
            if (this.httpStatusToOAuth2ErrorCodeMap.containsKey(statusCode)) {
                return new OAuth2Error(this.httpStatusToOAuth2ErrorCodeMap.get(statusCode), null, "https://tools.ietf.org/html/rfc6750#section-3.1");
            }
            return null;
        }

        private Map<String, String> parseAuthParameters(String wwwAuthenticateHeader) {
            return Stream.of(wwwAuthenticateHeader).filter(header -> !StringUtils.isEmpty((Object)header)).filter(header -> header.toLowerCase().startsWith("bearer")).map(header -> header.substring("bearer".length())).map(header -> header.split(",")).flatMap(Stream::of).map(parameter -> parameter.split("=")).filter(parameter -> ((String[])parameter).length > 1).collect(Collectors.toMap(parameters -> parameters[0].trim(), parameters -> parameters[1].trim().replace("\"", "")));
        }

        private Mono<Void> handleWebClientResponseException(ClientRequest request, WebClientResponseException exception) {
            return Mono.justOrEmpty((Object)this.resolveErrorIfPossible(exception.getRawStatusCode())).flatMap(oauth2Error -> {
                Mono serverWebExchange = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveServerWebExchange(request);
                Mono clientRegistrationId = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveClientRegistrationId(request);
                return Mono.zip((Mono)ServerOAuth2AuthorizedClientExchangeFilterFunction.this.currentAuthenticationMono, (Mono)serverWebExchange, (Mono)clientRegistrationId).flatMap(tuple3 -> this.handleAuthorizationFailure((Authentication)tuple3.getT1(), ((Optional)tuple3.getT2()).orElse(null), new ClientAuthorizationException((OAuth2Error)oauth2Error, (String)tuple3.getT3(), (Throwable)exception)));
            });
        }

        private Mono<Void> handleAuthorizationException(ClientRequest request, OAuth2AuthorizationException exception) {
            Mono serverWebExchange = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveServerWebExchange(request);
            return Mono.zip((Mono)ServerOAuth2AuthorizedClientExchangeFilterFunction.this.currentAuthenticationMono, (Mono)serverWebExchange).flatMap(tuple2 -> this.handleAuthorizationFailure((Authentication)tuple2.getT1(), ((Optional)tuple2.getT2()).orElse(null), exception));
        }

        private Mono<Void> handleAuthorizationFailure(Authentication principal, ServerWebExchange exchange, OAuth2AuthorizationException exception) {
            return this.authorizationFailureHandler.onAuthorizationFailure(exception, principal, this.createAttributes(exchange));
        }

        private Map<String, Object> createAttributes(ServerWebExchange exchange) {
            if (exchange == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(ServerWebExchange.class.getName(), exchange);
        }
    }

    private static class UnAuthenticatedReactiveOAuth2AuthorizedClientManager
    implements ReactiveOAuth2AuthorizedClientManager {
        private final ReactiveClientRegistrationRepository clientRegistrationRepository;
        private final UnAuthenticatedServerOAuth2AuthorizedClientRepository authorizedClientRepository;
        private final ReactiveOAuth2AuthorizationSuccessHandler authorizationSuccessHandler;
        private final ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler;
        private ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider;

        private UnAuthenticatedReactiveOAuth2AuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, UnAuthenticatedServerOAuth2AuthorizedClientRepository authorizedClientRepository, ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler) {
            this.clientRegistrationRepository = clientRegistrationRepository;
            this.authorizedClientRepository = authorizedClientRepository;
            this.authorizationSuccessHandler = (authorizedClient, principal, attributes) -> authorizedClientRepository.saveAuthorizedClient(authorizedClient, principal, null);
            this.authorizationFailureHandler = authorizationFailureHandler;
        }

        @Override
        public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizeRequest authorizeRequest) {
            Assert.notNull((Object)authorizeRequest, (String)"authorizeRequest cannot be null");
            String clientRegistrationId = authorizeRequest.getClientRegistrationId();
            Authentication principal = authorizeRequest.getPrincipal();
            return Mono.justOrEmpty((Object)authorizeRequest.getAuthorizedClient()).switchIfEmpty(Mono.defer(() -> this.authorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal, null))).flatMap(authorizedClient -> Mono.just((Object)OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient).principal(principal).build()).flatMap(authorizationContext -> this.authorize((OAuth2AuthorizationContext)authorizationContext, principal)).defaultIfEmpty((Object)(authorizeRequest.getAuthorizedClient() != null ? authorizeRequest.getAuthorizedClient() : authorizedClient))).switchIfEmpty(Mono.deferWithContext(context -> this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("Could not find ClientRegistration with id '" + clientRegistrationId + "'"))).flatMap(clientRegistration -> Mono.just((Object)OAuth2AuthorizationContext.withClientRegistration(clientRegistration).principal(principal).build())).flatMap(authorizationContext -> this.authorize((OAuth2AuthorizationContext)authorizationContext, principal)).subscriberContext(context)));
        }

        private Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizationContext authorizationContext, Authentication principal) {
            return this.authorizedClientProvider.authorize(authorizationContext).flatMap(authorizedClient -> this.authorizationSuccessHandler.onAuthorizationSuccess((OAuth2AuthorizedClient)authorizedClient, principal, Collections.emptyMap()).thenReturn(authorizedClient)).onErrorResume(OAuth2AuthorizationException.class, authorizationException -> this.authorizationFailureHandler.onAuthorizationFailure((OAuth2AuthorizationException)((Object)authorizationException), principal, Collections.emptyMap()).then(Mono.error((Throwable)authorizationException)));
        }

        private void setAuthorizedClientProvider(ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider) {
            Assert.notNull((Object)authorizedClientProvider, (String)"authorizedClientProvider cannot be null");
            this.authorizedClientProvider = authorizedClientProvider;
        }
    }

    @FunctionalInterface
    private static interface ClientResponseHandler {
        public Mono<ClientResponse> handleResponse(ClientRequest var1, Mono<ClientResponse> var2);
    }
}

