/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.userinfo;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class OAuth2UserRequest {
    private final ClientRegistration clientRegistration;
    private final OAuth2AccessToken accessToken;
    private final Map<String, Object> additionalParameters;

    public OAuth2UserRequest(ClientRegistration clientRegistration, OAuth2AccessToken accessToken) {
        this(clientRegistration, accessToken, Collections.emptyMap());
    }

    public OAuth2UserRequest(ClientRegistration clientRegistration, OAuth2AccessToken accessToken, Map<String, Object> additionalParameters) {
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        Assert.notNull((Object)accessToken, (String)"accessToken cannot be null");
        this.clientRegistration = clientRegistration;
        this.accessToken = accessToken;
        this.additionalParameters = Collections.unmodifiableMap(CollectionUtils.isEmpty(additionalParameters) ? Collections.emptyMap() : new LinkedHashMap<String, Object>(additionalParameters));
    }

    public ClientRegistration getClientRegistration() {
        return this.clientRegistration;
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }
}

