/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public class JwtBearerGrantRequest
extends AbstractOAuth2AuthorizationGrantRequest {
    private final Jwt jwt;

    public JwtBearerGrantRequest(ClientRegistration clientRegistration, Jwt jwt) {
        super(AuthorizationGrantType.JWT_BEARER, clientRegistration);
        Assert.isTrue((boolean)AuthorizationGrantType.JWT_BEARER.equals((Object)clientRegistration.getAuthorizationGrantType()), (String)"clientRegistration.authorizationGrantType must be AuthorizationGrantType.JWT_BEARER");
        Assert.notNull((Object)jwt, (String)"jwt cannot be null");
        this.jwt = jwt;
    }

    public Jwt getJwt() {
        return this.jwt;
    }
}

