/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.http;

import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import java.io.IOException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;

public class OAuth2ErrorResponseErrorHandler
implements ResponseErrorHandler {
    private HttpMessageConverter<OAuth2Error> oauth2ErrorConverter = new OAuth2ErrorHttpMessageConverter();
    private final ResponseErrorHandler defaultErrorHandler = new DefaultResponseErrorHandler();

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return this.defaultErrorHandler.hasError(response);
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        OAuth2Error oauth2Error;
        if (HttpStatus.BAD_REQUEST.value() != response.getRawStatusCode()) {
            this.defaultErrorHandler.handleError(response);
        }
        if ((oauth2Error = this.readErrorFromWwwAuthenticate(response.getHeaders())) == null) {
            oauth2Error = (OAuth2Error)this.oauth2ErrorConverter.read(OAuth2Error.class, (HttpInputMessage)response);
        }
        throw new OAuth2AuthorizationException(oauth2Error);
    }

    private OAuth2Error readErrorFromWwwAuthenticate(HttpHeaders headers) {
        String wwwAuthenticateHeader = headers.getFirst("WWW-Authenticate");
        if (!StringUtils.hasText((String)wwwAuthenticateHeader)) {
            return null;
        }
        BearerTokenError bearerTokenError = this.getBearerToken(wwwAuthenticateHeader);
        if (bearerTokenError == null) {
            return new OAuth2Error("server_error", null, null);
        }
        String errorCode = bearerTokenError.getCode() != null ? bearerTokenError.getCode() : "server_error";
        String errorDescription = bearerTokenError.getDescription();
        String errorUri = bearerTokenError.getURI() != null ? bearerTokenError.getURI().toString() : null;
        return new OAuth2Error(errorCode, errorDescription, errorUri);
    }

    private BearerTokenError getBearerToken(String wwwAuthenticateHeader) {
        try {
            return BearerTokenError.parse((String)wwwAuthenticateHeader);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final void setErrorConverter(HttpMessageConverter<OAuth2Error> oauth2ErrorConverter) {
        Assert.notNull(oauth2ErrorConverter, (String)"oauth2ErrorConverter cannot be null");
        this.oauth2ErrorConverter = oauth2ErrorConverter;
    }
}

