/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.util.Assert;

public class TokenExchangeGrantRequest
extends AbstractOAuth2AuthorizationGrantRequest {
    private final OAuth2Token subjectToken;
    private final OAuth2Token actorToken;

    public TokenExchangeGrantRequest(ClientRegistration clientRegistration, OAuth2Token subjectToken, OAuth2Token actorToken) {
        super(AuthorizationGrantType.TOKEN_EXCHANGE, clientRegistration);
        Assert.isTrue((boolean)AuthorizationGrantType.TOKEN_EXCHANGE.equals((Object)clientRegistration.getAuthorizationGrantType()), (String)"clientRegistration.authorizationGrantType must be AuthorizationGrantType.TOKEN_EXCHANGE");
        Assert.notNull((Object)subjectToken, (String)"subjectToken cannot be null");
        this.subjectToken = subjectToken;
        this.actorToken = actorToken;
    }

    public OAuth2Token getSubjectToken() {
        return this.subjectToken;
    }

    public OAuth2Token getActorToken() {
        return this.actorToken;
    }
}

