/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Collection;
import org.springframework.security.oauth2.client.endpoint.AbstractRestClientOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.CollectionUtils;

public final class RestClientRefreshTokenTokenResponseClient
extends AbstractRestClientOAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> {
    @Override
    public OAuth2AccessTokenResponse getTokenResponse(OAuth2RefreshTokenGrantRequest grantRequest) {
        OAuth2AccessTokenResponse accessTokenResponse = super.getTokenResponse(grantRequest);
        return this.populateTokenResponse(grantRequest, accessTokenResponse);
    }

    private OAuth2AccessTokenResponse populateTokenResponse(OAuth2RefreshTokenGrantRequest grantRequest, OAuth2AccessTokenResponse accessTokenResponse) {
        if (!CollectionUtils.isEmpty((Collection)accessTokenResponse.getAccessToken().getScopes()) && accessTokenResponse.getRefreshToken() != null) {
            return accessTokenResponse;
        }
        OAuth2AccessTokenResponse.Builder tokenResponseBuilder = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)accessTokenResponse);
        if (CollectionUtils.isEmpty((Collection)accessTokenResponse.getAccessToken().getScopes())) {
            tokenResponseBuilder.scopes(grantRequest.getAccessToken().getScopes());
        }
        if (accessTokenResponse.getRefreshToken() == null) {
            tokenResponseBuilder.refreshToken(grantRequest.getRefreshToken().getTokenValue());
        }
        return tokenResponseBuilder.build();
    }
}

