/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.function.Supplier;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderInitializationException;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.util.function.SingletonSupplier;

public final class SupplierJwtDecoder
implements JwtDecoder {
    private final Supplier<JwtDecoder> delegate = SingletonSupplier.of(() -> {
        try {
            return (JwtDecoder)jwtDecoderSupplier.get();
        }
        catch (Exception ex) {
            throw this.wrapException(ex);
        }
    });

    public SupplierJwtDecoder(Supplier<JwtDecoder> jwtDecoderSupplier) {
    }

    @Override
    public Jwt decode(String token) throws JwtException {
        return this.delegate.get().decode(token);
    }

    private JwtDecoderInitializationException wrapException(Exception ex) {
        return new JwtDecoderInitializationException("Failed to lazily resolve the supplied JwtDecoder instance", ex);
    }
}

