/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtAudienceValidator;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.JwtTypeValidator;
import org.springframework.security.oauth2.jwt.X509CertificateThumbprintValidator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class JwtValidators {
    private JwtValidators() {
    }

    public static OAuth2TokenValidator<Jwt> createDefaultWithIssuer(String issuer) {
        return JwtValidators.createDefaultWithValidators(new JwtIssuerValidator(issuer));
    }

    public static OAuth2TokenValidator<Jwt> createDefault() {
        return new DelegatingOAuth2TokenValidator(Arrays.asList(new JwtTimestampValidator(), new X509CertificateThumbprintValidator(X509CertificateThumbprintValidator.DEFAULT_X509_CERTIFICATE_SUPPLIER)));
    }

    public static OAuth2TokenValidator<Jwt> createDefaultWithValidators(List<OAuth2TokenValidator<Jwt>> validators) {
        JwtTimestampValidator jwtTimestampValidator;
        Assert.notEmpty(validators, (String)"validators cannot be null or empty");
        ArrayList<OAuth2TokenValidator<Jwt>> tokenValidators = new ArrayList<OAuth2TokenValidator<Jwt>>(validators);
        X509CertificateThumbprintValidator x509CertificateThumbprintValidator = (X509CertificateThumbprintValidator)CollectionUtils.findValueOfType(tokenValidators, X509CertificateThumbprintValidator.class);
        if (x509CertificateThumbprintValidator == null) {
            tokenValidators.add(0, new X509CertificateThumbprintValidator(X509CertificateThumbprintValidator.DEFAULT_X509_CERTIFICATE_SUPPLIER));
        }
        if ((jwtTimestampValidator = (JwtTimestampValidator)CollectionUtils.findValueOfType(tokenValidators, JwtTimestampValidator.class)) == null) {
            tokenValidators.add(0, new JwtTimestampValidator());
        }
        return new DelegatingOAuth2TokenValidator(tokenValidators);
    }

    public static OAuth2TokenValidator<Jwt> createDefaultWithValidators(OAuth2TokenValidator<Jwt> ... validators) {
        Assert.notEmpty((Object[])validators, (String)"validators cannot be null or empty");
        ArrayList<OAuth2TokenValidator<Jwt>> tokenValidators = new ArrayList<OAuth2TokenValidator<Jwt>>(Arrays.asList(validators));
        return JwtValidators.createDefaultWithValidators(tokenValidators);
    }

    public static AtJwtBuilder createAtJwtValidator() {
        return new AtJwtBuilder();
    }

    private static RequireClaimValidator require(String claim) {
        return new RequireClaimValidator(claim);
    }

    public static final class AtJwtBuilder {
        Map<String, OAuth2TokenValidator<Jwt>> validators = new LinkedHashMap<String, OAuth2TokenValidator<Jwt>>();

        private AtJwtBuilder() {
            JwtTimestampValidator timestamps = new JwtTimestampValidator();
            this.validators.put("typ", new JwtTypeValidator(List.of("at+jwt", "application/at+jwt")));
            this.validators.put("exp", JwtValidators.require("exp").and(timestamps));
            this.validators.put("sub", JwtValidators.require("sub"));
            this.validators.put("iat", JwtValidators.require("iat").and(timestamps));
            this.validators.put("jti", JwtValidators.require("jti"));
        }

        public AtJwtBuilder issuer(String issuer) {
            return this.validators(v -> v.put("iss", new JwtIssuerValidator(issuer)));
        }

        public AtJwtBuilder audience(String audience) {
            return this.validators(v -> v.put("aud", new JwtAudienceValidator(audience)));
        }

        public AtJwtBuilder clientId(String clientId) {
            return this.validators(v -> v.put("client_id", JwtValidators.require("client_id").isEqualTo(clientId)));
        }

        public AtJwtBuilder validators(Consumer<Map<String, OAuth2TokenValidator<Jwt>>> validators) {
            validators.accept(this.validators);
            return this;
        }

        public OAuth2TokenValidator<Jwt> build() {
            List.of("typ", "exp", "sub", "iat", "jti", "iss", "aud", "client_id").forEach(name -> Assert.isTrue((boolean)this.validators.containsKey(name), (String)(name + " must be validated")));
            return new DelegatingOAuth2TokenValidator(this.validators.values());
        }
    }

    private static final class RequireClaimValidator
    implements OAuth2TokenValidator<Jwt> {
        private final String claimName;

        RequireClaimValidator(String claimName) {
            this.claimName = claimName;
        }

        public OAuth2TokenValidatorResult validate(Jwt token) {
            if (token.getClaim(this.claimName) == null) {
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", this.claimName + " must have a value", "https://datatracker.ietf.org/doc/html/rfc9068#name-data-structure")});
            }
            return OAuth2TokenValidatorResult.success();
        }

        OAuth2TokenValidator<Jwt> isEqualTo(String value) {
            return this.and(this.satisfies(jwt -> value.equals(jwt.getClaim(this.claimName))));
        }

        OAuth2TokenValidator<Jwt> satisfies(Predicate<Jwt> predicate) {
            return this.and((OAuth2TokenValidator<Jwt>)((OAuth2TokenValidator)jwt -> {
                OAuth2Error error = new OAuth2Error("invalid_token", this.claimName + " is not valid", "https://datatracker.ietf.org/doc/html/rfc9068#name-data-structure");
                if (predicate.test((Jwt)jwt)) {
                    return OAuth2TokenValidatorResult.success();
                }
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
            }));
        }

        OAuth2TokenValidator<Jwt> and(OAuth2TokenValidator<Jwt> that) {
            return jwt -> {
                OAuth2TokenValidatorResult result = this.validate((Jwt)jwt);
                return result.hasErrors() ? result : that.validate(jwt);
            };
        }
    }
}

