/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class JwtReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private final JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
    private final ReactiveJwtDecoder jwtDecoder;

    public JwtReactiveAuthenticationManager(ReactiveJwtDecoder jwtDecoder) {
        Assert.notNull((Object)jwtDecoder, (String)"jwtDecoder cannot be null");
        this.jwtDecoder = jwtDecoder;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.justOrEmpty((Object)authentication).filter(a -> a instanceof BearerTokenAuthenticationToken).cast(BearerTokenAuthenticationToken.class).map(BearerTokenAuthenticationToken::getToken).flatMap(arg_0 -> ((ReactiveJwtDecoder)this.jwtDecoder).decode(arg_0)).map(this.jwtAuthenticationConverter::convert).cast(Authentication.class).onErrorMap(JwtException.class, this::onError);
    }

    private OAuth2AuthenticationException onError(JwtException e) {
        OAuth2Error invalidRequest = JwtReactiveAuthenticationManager.invalidToken(e.getMessage());
        return new OAuth2AuthenticationException(invalidRequest, e.getMessage());
    }

    private static OAuth2Error invalidToken(String message) {
        return new BearerTokenError("invalid_token", HttpStatus.UNAUTHORIZED, message, "https://tools.ietf.org/html/rfc6750#section-3.1");
    }
}

