/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web.access.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class BearerTokenServerAccessDeniedHandler
implements ServerAccessDeniedHandler {
    private static final Collection<String> WELL_KNOWN_SCOPE_ATTRIBUTE_NAMES = Arrays.asList("scope", "scp");
    private String realmName;

    public Mono<Void> handle(ServerWebExchange exchange, AccessDeniedException denied) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.realmName != null) {
            parameters.put("realm", this.realmName);
        }
        return exchange.getPrincipal().filter(AbstractOAuth2TokenAuthenticationToken.class::isInstance).cast(AbstractOAuth2TokenAuthenticationToken.class).map(token -> BearerTokenServerAccessDeniedHandler.errorMessageParameters(token, parameters)).switchIfEmpty(Mono.just(parameters)).flatMap(params -> BearerTokenServerAccessDeniedHandler.respond(exchange, params));
    }

    public final void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    private static Map<String, String> errorMessageParameters(AbstractOAuth2TokenAuthenticationToken token, Map<String, String> parameters) {
        String scope = BearerTokenServerAccessDeniedHandler.getScope(token);
        parameters.put("error", "insufficient_scope");
        parameters.put("error_description", String.format("The token provided has insufficient scope [%s] for this request", scope));
        parameters.put("error_uri", "https://tools.ietf.org/html/rfc6750#section-3.1");
        if (StringUtils.hasText((String)scope)) {
            parameters.put("scope", scope);
        }
        return parameters;
    }

    private static Mono<Void> respond(ServerWebExchange exchange, Map<String, String> parameters) {
        String wwwAuthenticate = BearerTokenServerAccessDeniedHandler.computeWWWAuthenticateHeaderValue(parameters);
        exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
        exchange.getResponse().getHeaders().set("WWW-Authenticate", wwwAuthenticate);
        return exchange.getResponse().setComplete();
    }

    private static String getScope(AbstractOAuth2TokenAuthenticationToken token) {
        Map<String, Object> attributes = token.getTokenAttributes();
        for (String attributeName : WELL_KNOWN_SCOPE_ATTRIBUTE_NAMES) {
            Object scopes = attributes.get(attributeName);
            if (scopes instanceof String) {
                return (String)scopes;
            }
            if (!(scopes instanceof Collection)) continue;
            Collection coll = (Collection)scopes;
            return coll.stream().map(String::valueOf).collect(Collectors.joining(" "));
        }
        return "";
    }

    private static String computeWWWAuthenticateHeaderValue(Map<String, String> parameters) {
        String wwwAuthenticate = "Bearer";
        if (!parameters.isEmpty()) {
            wwwAuthenticate = wwwAuthenticate + parameters.entrySet().stream().map(attribute -> (String)attribute.getKey() + "=\"" + (String)attribute.getValue() + "\"").collect(Collectors.joining(", ", " ", ""));
        }
        return wwwAuthenticate;
    }
}

