/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerBearerTokenAuthenticationConverter
implements ServerAuthenticationConverter {
    private static final Pattern authorizationPattern = Pattern.compile("^Bearer (?<token>[a-zA-Z0-9-._~+/]+=*)$");
    private boolean allowUriQueryParameter = false;

    public Mono<Authentication> convert(ServerWebExchange exchange) {
        return Mono.fromCallable(() -> this.token(exchange.getRequest())).map(token -> {
            if (token.isEmpty()) {
                BearerTokenError error = ServerBearerTokenAuthenticationConverter.invalidTokenError();
                throw new OAuth2AuthenticationException((OAuth2Error)error);
            }
            return new BearerTokenAuthenticationToken((String)token);
        });
    }

    private String token(ServerHttpRequest request) {
        String authorizationHeaderToken = ServerBearerTokenAuthenticationConverter.resolveFromAuthorizationHeader(request.getHeaders());
        String parameterToken = (String)request.getQueryParams().getFirst((Object)"access_token");
        if (authorizationHeaderToken != null) {
            if (parameterToken != null) {
                BearerTokenError error = new BearerTokenError("invalid_request", HttpStatus.BAD_REQUEST, "Found multiple bearer tokens in the request", "https://tools.ietf.org/html/rfc6750#section-3.1");
                throw new OAuth2AuthenticationException((OAuth2Error)error);
            }
            return authorizationHeaderToken;
        }
        if (parameterToken != null && this.isParameterTokenSupportedForRequest(request)) {
            return parameterToken;
        }
        return null;
    }

    public void setAllowUriQueryParameter(boolean allowUriQueryParameter) {
        this.allowUriQueryParameter = allowUriQueryParameter;
    }

    private static String resolveFromAuthorizationHeader(HttpHeaders headers) {
        String authorization = headers.getFirst("Authorization");
        if (StringUtils.hasText((String)authorization) && authorization.startsWith("Bearer")) {
            Matcher matcher = authorizationPattern.matcher(authorization);
            if (!matcher.matches()) {
                BearerTokenError error = ServerBearerTokenAuthenticationConverter.invalidTokenError();
                throw new OAuth2AuthenticationException((OAuth2Error)error);
            }
            return matcher.group("token");
        }
        return null;
    }

    private static BearerTokenError invalidTokenError() {
        return new BearerTokenError("invalid_token", HttpStatus.UNAUTHORIZED, "Bearer token is malformed", "https://tools.ietf.org/html/rfc6750#section-3.1");
    }

    private boolean isParameterTokenSupportedForRequest(ServerHttpRequest request) {
        return this.allowUriQueryParameter && HttpMethod.GET.equals((Object)request.getMethod());
    }
}

