/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.ReactiveJwtAuthenticationConverterAdapter;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class JwtReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter = new ReactiveJwtAuthenticationConverterAdapter(new JwtAuthenticationConverter());
    private final ReactiveJwtDecoder jwtDecoder;

    public JwtReactiveAuthenticationManager(ReactiveJwtDecoder jwtDecoder) {
        Assert.notNull((Object)jwtDecoder, (String)"jwtDecoder cannot be null");
        this.jwtDecoder = jwtDecoder;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.justOrEmpty((Object)authentication).filter(a -> a instanceof BearerTokenAuthenticationToken).cast(BearerTokenAuthenticationToken.class).map(BearerTokenAuthenticationToken::getToken).flatMap(arg_0 -> ((ReactiveJwtDecoder)this.jwtDecoder).decode(arg_0)).flatMap(arg_0 -> this.jwtAuthenticationConverter.convert(arg_0)).cast(Authentication.class).onErrorMap(JwtException.class, this::onError);
    }

    public void setJwtAuthenticationConverter(Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter) {
        Assert.notNull(jwtAuthenticationConverter, (String)"jwtAuthenticationConverter cannot be null");
        this.jwtAuthenticationConverter = jwtAuthenticationConverter;
    }

    private OAuth2AuthenticationException onError(JwtException e) {
        OAuth2Error invalidRequest = JwtReactiveAuthenticationManager.invalidToken(e.getMessage());
        return new OAuth2AuthenticationException(invalidRequest, e.getMessage());
    }

    private static OAuth2Error invalidToken(String message) {
        return new BearerTokenError("invalid_token", HttpStatus.UNAUTHORIZED, message, "https://tools.ietf.org/html/rfc6750#section-3.1");
    }
}

