/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource;

import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.server.resource.BearerTokenError;

public final class BearerTokenErrors {
    private static final BearerTokenError DEFAULT_INVALID_REQUEST = BearerTokenErrors.invalidRequest("Invalid request");
    private static final BearerTokenError DEFAULT_INVALID_TOKEN = BearerTokenErrors.invalidToken("Invalid token");
    private static final BearerTokenError DEFAULT_INSUFFICIENT_SCOPE = BearerTokenErrors.insufficientScope("Insufficient scope", null);
    private static final String DEFAULT_URI = "https://tools.ietf.org/html/rfc6750#section-3.1";

    private BearerTokenErrors() {
    }

    public static BearerTokenError invalidRequest(String message) {
        try {
            return new BearerTokenError("invalid_request", HttpStatus.BAD_REQUEST, message, DEFAULT_URI);
        }
        catch (IllegalArgumentException ex) {
            return DEFAULT_INVALID_REQUEST;
        }
    }

    public static BearerTokenError invalidToken(String message) {
        try {
            return new BearerTokenError("invalid_token", HttpStatus.UNAUTHORIZED, message, DEFAULT_URI);
        }
        catch (IllegalArgumentException ex) {
            return DEFAULT_INVALID_TOKEN;
        }
    }

    public static BearerTokenError insufficientScope(String message, String scope) {
        try {
            return new BearerTokenError("insufficient_scope", HttpStatus.FORBIDDEN, message, DEFAULT_URI, scope);
        }
        catch (IllegalArgumentException ex) {
            return DEFAULT_INSUFFICIENT_SCOPE;
        }
    }
}

