/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import com.nimbusds.jose.jwk.JWK;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.function.Function;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.ClaimAccessor;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.DPoPProofContext;
import org.springframework.security.oauth2.jwt.DPoPProofJwtDecoderFactory;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.DPoPAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class DPoPAuthenticationProvider
implements AuthenticationProvider {
    private final AuthenticationManager tokenAuthenticationManager;
    private JwtDecoderFactory<DPoPProofContext> dPoPProofVerifierFactory;

    public DPoPAuthenticationProvider(AuthenticationManager tokenAuthenticationManager) {
        Assert.notNull((Object)tokenAuthenticationManager, (String)"tokenAuthenticationManager cannot be null");
        this.tokenAuthenticationManager = tokenAuthenticationManager;
        Function<DPoPProofContext, OAuth2TokenValidator> jwtValidatorFactory = context -> new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{(OAuth2TokenValidator)DPoPProofJwtDecoderFactory.DEFAULT_JWT_VALIDATOR_FACTORY.apply(context), new AthClaimValidator((OAuth2AccessTokenClaims)context.getAccessToken()), new JwkThumbprintValidator((OAuth2AccessTokenClaims)context.getAccessToken())});
        DPoPProofJwtDecoderFactory dPoPProofJwtDecoderFactory = new DPoPProofJwtDecoderFactory();
        dPoPProofJwtDecoderFactory.setJwtValidatorFactory(jwtValidatorFactory);
        this.dPoPProofVerifierFactory = dPoPProofJwtDecoderFactory;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        DPoPAuthenticationToken dPoPAuthenticationToken = (DPoPAuthenticationToken)authentication;
        BearerTokenAuthenticationToken accessTokenAuthenticationRequest = new BearerTokenAuthenticationToken(dPoPAuthenticationToken.getAccessToken());
        Authentication accessTokenAuthenticationResult = this.tokenAuthenticationManager.authenticate((Authentication)accessTokenAuthenticationRequest);
        AbstractOAuth2TokenAuthenticationToken accessTokenAuthentication = null;
        if (accessTokenAuthenticationResult instanceof AbstractOAuth2TokenAuthenticationToken) {
            accessTokenAuthentication = (AbstractOAuth2TokenAuthenticationToken)accessTokenAuthenticationResult;
        }
        if (accessTokenAuthentication == null) {
            OAuth2Error error = new OAuth2Error("invalid_token", "Unable to authenticate the DPoP-bound access token.", null);
            throw new OAuth2AuthenticationException(error);
        }
        OAuth2AccessTokenClaims accessToken = new OAuth2AccessTokenClaims((OAuth2Token)accessTokenAuthentication.getToken(), accessTokenAuthentication.getTokenAttributes());
        DPoPProofContext dPoPProofContext = DPoPProofContext.withDPoPProof((String)dPoPAuthenticationToken.getDPoPProof()).accessToken((OAuth2Token)accessToken).method(dPoPAuthenticationToken.getMethod()).targetUri(dPoPAuthenticationToken.getResourceUri()).build();
        JwtDecoder dPoPProofVerifier = this.dPoPProofVerifierFactory.createDecoder((Object)dPoPProofContext);
        try {
            dPoPProofVerifier.decode(dPoPProofContext.getDPoPProof());
        }
        catch (JwtException ex) {
            OAuth2Error error = new OAuth2Error("invalid_dpop_proof");
            throw new OAuth2AuthenticationException(error, (Throwable)ex);
        }
        return accessTokenAuthenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return DPoPAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setDPoPProofVerifierFactory(JwtDecoderFactory<DPoPProofContext> dPoPProofVerifierFactory) {
        Assert.notNull(dPoPProofVerifierFactory, (String)"dPoPProofVerifierFactory cannot be null");
        this.dPoPProofVerifierFactory = dPoPProofVerifierFactory;
    }

    private static final class OAuth2AccessTokenClaims
    implements OAuth2Token,
    ClaimAccessor {
        private final OAuth2Token accessToken;
        private final Map<String, Object> claims;

        private OAuth2AccessTokenClaims(OAuth2Token accessToken, Map<String, Object> claims) {
            this.accessToken = accessToken;
            this.claims = claims;
        }

        public String getTokenValue() {
            return this.accessToken.getTokenValue();
        }

        public Instant getIssuedAt() {
            return this.accessToken.getIssuedAt();
        }

        public Instant getExpiresAt() {
            return this.accessToken.getExpiresAt();
        }

        public Map<String, Object> getClaims() {
            return this.claims;
        }
    }

    private static final class AthClaimValidator
    implements OAuth2TokenValidator<Jwt> {
        private final OAuth2AccessTokenClaims accessToken;

        private AthClaimValidator(OAuth2AccessTokenClaims accessToken) {
            Assert.notNull((Object)accessToken, (String)"accessToken cannot be null");
            this.accessToken = accessToken;
        }

        public OAuth2TokenValidatorResult validate(Jwt jwt) {
            String accessTokenHash;
            Assert.notNull((Object)jwt, (String)"DPoP proof jwt cannot be null");
            String accessTokenHashClaim = jwt.getClaimAsString("ath");
            if (!StringUtils.hasText((String)accessTokenHashClaim)) {
                OAuth2Error error = AthClaimValidator.createOAuth2Error("ath claim is required.");
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
            }
            try {
                accessTokenHash = AthClaimValidator.computeSHA256(this.accessToken.getTokenValue());
            }
            catch (Exception ex) {
                OAuth2Error error = AthClaimValidator.createOAuth2Error("Failed to compute SHA-256 Thumbprint for access token.");
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
            }
            if (!accessTokenHashClaim.equals(accessTokenHash)) {
                OAuth2Error error = AthClaimValidator.createOAuth2Error("ath claim is invalid.");
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
            }
            return OAuth2TokenValidatorResult.success();
        }

        private static OAuth2Error createOAuth2Error(String reason) {
            return new OAuth2Error("invalid_dpop_proof", reason, null);
        }

        private static String computeSHA256(String value) throws Exception {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(value.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
        }
    }

    private static final class JwkThumbprintValidator
    implements OAuth2TokenValidator<Jwt> {
        private final OAuth2AccessTokenClaims accessToken;

        private JwkThumbprintValidator(OAuth2AccessTokenClaims accessToken) {
            Assert.notNull((Object)accessToken, (String)"accessToken cannot be null");
            this.accessToken = accessToken;
        }

        public OAuth2TokenValidatorResult validate(Jwt jwt) {
            String jwkThumbprint;
            Assert.notNull((Object)jwt, (String)"DPoP proof jwt cannot be null");
            String jwkThumbprintClaim = null;
            Map confirmationMethodClaim = this.accessToken.getClaimAsMap("cnf");
            if (!CollectionUtils.isEmpty((Map)confirmationMethodClaim) && confirmationMethodClaim.containsKey("jkt")) {
                jwkThumbprintClaim = (String)confirmationMethodClaim.get("jkt");
            }
            if (jwkThumbprintClaim == null) {
                OAuth2Error error = JwkThumbprintValidator.createOAuth2Error("jkt claim is required.");
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
            }
            JWK jwk = null;
            Map jwkJson = (Map)jwt.getHeaders().get("jwk");
            try {
                jwk = JWK.parse((Map)jwkJson);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jwk == null) {
                OAuth2Error error = JwkThumbprintValidator.createOAuth2Error("jwk header is missing or invalid.");
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
            }
            try {
                jwkThumbprint = jwk.computeThumbprint().toString();
            }
            catch (Exception ex) {
                OAuth2Error error = JwkThumbprintValidator.createOAuth2Error("Failed to compute SHA-256 Thumbprint for jwk.");
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
            }
            if (!jwkThumbprintClaim.equals(jwkThumbprint)) {
                OAuth2Error error = JwkThumbprintValidator.createOAuth2Error("jkt claim is invalid.");
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
            }
            return OAuth2TokenValidatorResult.success();
        }

        private static OAuth2Error createOAuth2Error(String reason) {
            return new OAuth2Error("invalid_dpop_proof", reason, null);
        }
    }
}

