/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.openid;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.security.openid.AxFetchListFactory;
import org.springframework.security.openid.OpenIDAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexBasedAxFetchListFactory
implements AxFetchListFactory {
    private final Map<Pattern, List<OpenIDAttribute>> idToAttributes = new LinkedHashMap<Pattern, List<OpenIDAttribute>>();

    public RegexBasedAxFetchListFactory(Map<String, List<OpenIDAttribute>> regexMap) {
        for (Map.Entry<String, List<OpenIDAttribute>> entry : regexMap.entrySet()) {
            this.idToAttributes.put(Pattern.compile(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public List<OpenIDAttribute> createAttributeList(String identifier) {
        for (Map.Entry<Pattern, List<OpenIDAttribute>> entry : this.idToAttributes.entrySet()) {
            if (!entry.getKey().matcher(identifier).matches()) continue;
            return entry.getValue();
        }
        return Collections.emptyList();
    }
}

