/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.openid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.openid.OpenIDAttribute;
import org.springframework.security.openid.OpenIDAuthenticationStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIDAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 400L;
    private final OpenIDAuthenticationStatus status;
    private final Object principal;
    private final String identityUrl;
    private final String message;
    private final List<OpenIDAttribute> attributes;

    public OpenIDAuthenticationToken(OpenIDAuthenticationStatus status, String identityUrl, String message, List<OpenIDAttribute> attributes) {
        super(new ArrayList(0));
        this.principal = identityUrl;
        this.status = status;
        this.identityUrl = identityUrl;
        this.message = message;
        this.attributes = attributes;
        this.setAuthenticated(false);
    }

    public OpenIDAuthenticationToken(Object principal, Collection<? extends GrantedAuthority> authorities, String identityUrl, List<OpenIDAttribute> attributes) {
        super(authorities);
        this.principal = principal;
        this.status = OpenIDAuthenticationStatus.SUCCESS;
        this.identityUrl = identityUrl;
        this.message = null;
        this.attributes = attributes;
        this.setAuthenticated(true);
    }

    public Object getCredentials() {
        return null;
    }

    public String getIdentityUrl() {
        return this.identityUrl;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public OpenIDAuthenticationStatus getStatus() {
        return this.status;
    }

    public List<OpenIDAttribute> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "[" + super.toString() + ", attributes : " + this.attributes + "]";
    }
}

