/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.remoting.rmi;

import java.lang.reflect.InvocationTargetException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Deprecated
public class ContextPropagatingRemoteInvocation
extends RemoteInvocation {
    private static final long serialVersionUID = 560L;
    private static final Log logger = LogFactory.getLog(ContextPropagatingRemoteInvocation.class);
    private final String principal;
    private final String credentials;

    public ContextPropagatingRemoteInvocation(MethodInvocation methodInvocation) {
        super(methodInvocation);
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser != null) {
            this.principal = currentUser.getName();
            Object userCredentials = currentUser.getCredentials();
            this.credentials = userCredentials != null ? userCredentials.toString() : null;
        } else {
            this.credentials = null;
            this.principal = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteInvocation now has principal: " + this.principal));
            if (this.credentials == null) {
                logger.debug((Object)"RemoteInvocation now has null credentials.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.principal != null) {
            Authentication request = this.createAuthenticationRequest(this.principal, this.credentials);
            request.setAuthenticated(false);
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(request);
            SecurityContextHolder.setContext((SecurityContext)context);
            logger.debug((Object)LogMessage.format((String)"Set SecurityContextHolder to contain: %s", (Object)request));
        }
        try {
            Object object = super.invoke(targetObject);
            return object;
        }
        finally {
            SecurityContextHolder.clearContext();
            logger.debug((Object)"Cleared SecurityContextHolder.");
        }
    }

    protected Authentication createAuthenticationRequest(String principal, String credentials) {
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)credentials);
    }
}

