/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.credentials;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;

@Deprecated
public class Saml2X509Credential {
    private final PrivateKey privateKey;
    private final X509Certificate certificate;
    private final Set<Saml2X509CredentialType> credentialTypes;

    public Saml2X509Credential(X509Certificate certificate, Saml2X509CredentialType ... types) {
        this(null, false, certificate, types);
        this.validateUsages(types, Saml2X509CredentialType.VERIFICATION, Saml2X509CredentialType.ENCRYPTION);
    }

    public Saml2X509Credential(PrivateKey privateKey, X509Certificate certificate, Saml2X509CredentialType ... types) {
        this(privateKey, true, certificate, types);
        this.validateUsages(types, Saml2X509CredentialType.SIGNING, Saml2X509CredentialType.DECRYPTION);
    }

    public Saml2X509Credential(PrivateKey privateKey, X509Certificate certificate, Set<Saml2X509CredentialType> types) {
        Assert.notNull((Object)certificate, (String)"certificate cannot be null");
        Assert.notEmpty(types, (String)"credentialTypes cannot be empty");
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.credentialTypes = types;
    }

    private Saml2X509Credential(PrivateKey privateKey, boolean keyRequired, X509Certificate certificate, Saml2X509CredentialType ... types) {
        Assert.notNull((Object)certificate, (String)"certificate cannot be null");
        Assert.notEmpty((Object[])types, (String)"credentials types cannot be empty");
        if (keyRequired) {
            Assert.notNull((Object)privateKey, (String)"privateKey cannot be null");
        }
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.credentialTypes = new LinkedHashSet<Saml2X509CredentialType>(Arrays.asList(types));
    }

    public boolean isSigningCredential() {
        return this.getCredentialTypes().contains((Object)Saml2X509CredentialType.SIGNING);
    }

    public boolean isDecryptionCredential() {
        return this.getCredentialTypes().contains((Object)Saml2X509CredentialType.DECRYPTION);
    }

    public boolean isSignatureVerficationCredential() {
        return this.getCredentialTypes().contains((Object)Saml2X509CredentialType.VERIFICATION);
    }

    public boolean isEncryptionCredential() {
        return this.getCredentialTypes().contains((Object)Saml2X509CredentialType.ENCRYPTION);
    }

    protected Set<Saml2X509CredentialType> getCredentialTypes() {
        return this.credentialTypes;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Saml2X509Credential that = (Saml2X509Credential)o;
        return Objects.equals(this.privateKey, that.privateKey) && this.certificate.equals(that.certificate) && this.credentialTypes.equals(that.credentialTypes);
    }

    public int hashCode() {
        return Objects.hash(this.privateKey, this.certificate, this.credentialTypes);
    }

    private void validateUsages(Saml2X509CredentialType[] usages, Saml2X509CredentialType ... validUsages) {
        for (Saml2X509CredentialType usage : usages) {
            boolean valid = false;
            for (Saml2X509CredentialType validUsage : validUsages) {
                if (usage != validUsage) continue;
                valid = true;
                break;
            }
            Assert.state((boolean)valid, () -> (Object)((Object)usage) + " is not a valid usage for this credential");
        }
    }

    @Deprecated
    public static enum Saml2X509CredentialType {
        VERIFICATION,
        ENCRYPTION,
        SIGNING,
        DECRYPTION;

    }
}

