/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.criteria.role.impl.EvaluableProtocolRoleDescriptorCriterion;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.AudienceRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.impl.BearerSubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.DelegationRestrictionConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.impl.ResponseUnmarshaller;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.criteria.impl.EvaluableEntityIDCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableUsageCredentialCriterion;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2ResponseValidatorResult;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.DefaultSaml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class OpenSamlAuthenticationProvider
implements AuthenticationProvider {
    private static Log logger;
    private final XMLObjectProviderRegistry registry;
    private final ResponseUnmarshaller responseUnmarshaller;
    private final ParserPool parserPool;
    private Converter<Assertion, Collection<? extends GrantedAuthority>> authoritiesExtractor = a -> Collections.singletonList(new SimpleGrantedAuthority("ROLE_USER"));
    private GrantedAuthoritiesMapper authoritiesMapper = a -> a;
    private Duration responseTimeValidationSkew = Duration.ofMinutes(5L);
    private Converter<ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter = responseToken -> {
        Response response = ((ResponseToken)responseToken).response;
        Saml2AuthenticationToken token = ((ResponseToken)responseToken).token;
        Assertion assertion = (Assertion)CollectionUtils.firstElement((List)response.getAssertions());
        String username = assertion.getSubject().getNameID().getValue();
        Map<String, List<Object>> attributes = OpenSamlAuthenticationProvider.getAssertionAttributes(assertion);
        return new Saml2Authentication(new DefaultSaml2AuthenticatedPrincipal(username, attributes), token.getSaml2Response(), this.authoritiesMapper.mapAuthorities(this.getAssertionAuthorities(assertion)));
    };
    private Converter<AssertionToken, Saml2ResponseValidatorResult> assertionSignatureValidator = OpenSamlAuthenticationProvider.createDefaultAssertionValidator("invalid_signature", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> {
        SignatureTrustEngine engine = (SignatureTrustEngine)this.signatureTrustEngineConverter.convert((Object)((AssertionToken)assertionToken).token);
        return SAML20AssertionValidators.createSignatureValidator(engine);
    }), (Converter<AssertionToken, ValidationContext>)((Converter)assertionToken -> new ValidationContext(Collections.singletonMap("saml2.SignatureRequired", false))));
    private Converter<AssertionToken, Saml2ResponseValidatorResult> assertionValidator = OpenSamlAuthenticationProvider.createDefaultAssertionValidator("invalid_assertion", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> SAML20AssertionValidators.access$600()), (Converter<AssertionToken, ValidationContext>)((Converter)assertionToken -> OpenSamlAuthenticationProvider.createValidationContext(assertionToken, params -> params.put("saml2.ClockSkew", this.responseTimeValidationSkew.toMillis()))));
    private Converter<Saml2AuthenticationToken, SignatureTrustEngine> signatureTrustEngineConverter = new SignatureTrustEngineConverter();
    private Converter<Saml2AuthenticationToken, Decrypter> decrypterConverter = new DecrypterConverter();

    public OpenSamlAuthenticationProvider() {
        this.registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.responseUnmarshaller = (ResponseUnmarshaller)this.registry.getUnmarshallerFactory().getUnmarshaller(Response.DEFAULT_ELEMENT_NAME);
        this.parserPool = this.registry.getParserPool();
    }

    public void setAssertionValidator(Converter<AssertionToken, Saml2ResponseValidatorResult> assertionValidator) {
        Assert.notNull(assertionValidator, (String)"assertionValidator cannot be null");
        this.assertionValidator = assertionValidator;
    }

    public void setResponseAuthenticationConverter(Converter<ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter) {
        Assert.notNull(responseAuthenticationConverter, (String)"responseAuthenticationConverter cannot be null");
        this.responseAuthenticationConverter = responseAuthenticationConverter;
    }

    public void setAuthoritiesExtractor(Converter<Assertion, Collection<? extends GrantedAuthority>> authoritiesExtractor) {
        Assert.notNull(authoritiesExtractor, (String)"authoritiesExtractor cannot be null");
        this.authoritiesExtractor = authoritiesExtractor;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        Assert.notNull((Object)authoritiesMapper, (String)"authoritiesMapper cannot be null");
        this.authoritiesMapper = authoritiesMapper;
    }

    public void setResponseTimeValidationSkew(Duration responseTimeValidationSkew) {
        this.responseTimeValidationSkew = responseTimeValidationSkew;
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator() {
        return OpenSamlAuthenticationProvider.createDefaultAssertionValidator("invalid_assertion", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> SAML20AssertionValidators.attributeValidator), (Converter<AssertionToken, ValidationContext>)((Converter)assertionToken -> OpenSamlAuthenticationProvider.createValidationContext(assertionToken, params -> {})));
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator(Converter<AssertionToken, ValidationContext> contextConverter) {
        return OpenSamlAuthenticationProvider.createDefaultAssertionValidator("invalid_assertion", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> SAML20AssertionValidators.attributeValidator), contextConverter);
    }

    public static Converter<ResponseToken, Saml2Authentication> createDefaultResponseAuthenticationConverter() {
        return responseToken -> {
            Saml2AuthenticationToken token = ((ResponseToken)responseToken).token;
            Response response = ((ResponseToken)responseToken).response;
            Assertion assertion = (Assertion)CollectionUtils.firstElement((List)response.getAssertions());
            String username = assertion.getSubject().getNameID().getValue();
            Map<String, List<Object>> attributes = OpenSamlAuthenticationProvider.getAssertionAttributes(assertion);
            return new Saml2Authentication(new DefaultSaml2AuthenticatedPrincipal(username, attributes), token.getSaml2Response(), Collections.singleton(new SimpleGrantedAuthority("ROLE_USER")));
        };
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            Saml2AuthenticationToken token = (Saml2AuthenticationToken)authentication;
            String serializedResponse = token.getSaml2Response();
            Response response = this.parse(serializedResponse);
            this.process(token, response);
            return (Authentication)this.responseAuthenticationConverter.convert((Object)new ResponseToken(response, token));
        }
        catch (Saml2AuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw OpenSamlAuthenticationProvider.createAuthenticationException("internal_validation_error", ex.getMessage(), ex);
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication != null && Saml2AuthenticationToken.class.isAssignableFrom(authentication);
    }

    private Collection<? extends GrantedAuthority> getAssertionAuthorities(Assertion assertion) {
        return (Collection)this.authoritiesExtractor.convert((Object)assertion);
    }

    private Response parse(String response) throws Saml2Exception, Saml2AuthenticationException {
        try {
            Document document = this.parserPool.parse((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8)));
            Element element = document.getDocumentElement();
            return (Response)this.responseUnmarshaller.unmarshall(element);
        }
        catch (Exception ex) {
            throw OpenSamlAuthenticationProvider.createAuthenticationException("malformed_response_data", ex.getMessage(), ex);
        }
    }

    private void process(Saml2AuthenticationToken token, Response response) {
        String issuer = response.getIssuer().getValue();
        logger.debug((Object)LogMessage.format((String)"Processing SAML response from %s", (Object)issuer));
        boolean responseSigned = response.isSigned();
        Saml2ResponseValidatorResult result = this.validateResponse(token, response);
        Decrypter decrypter = (Decrypter)this.decrypterConverter.convert((Object)token);
        List<Assertion> assertions = this.decryptAssertions(decrypter, response);
        if (!this.isSigned(responseSigned, assertions)) {
            String description = "Either the response or one of the assertions is unsigned. Please either sign the response or all of the assertions.";
            throw OpenSamlAuthenticationProvider.createAuthenticationException("invalid_signature", description, null);
        }
        result = result.concat(this.validateAssertions(token, response));
        Assertion firstAssertion = (Assertion)CollectionUtils.firstElement((List)response.getAssertions());
        NameID nameId = this.decryptPrincipal(decrypter, firstAssertion);
        if (nameId == null || nameId.getValue() == null) {
            Saml2Error error = new Saml2Error("subject_not_found", "Assertion [" + firstAssertion.getID() + "] is missing a subject");
            result = result.concat(error);
        }
        if (result.hasErrors()) {
            Collection<Saml2Error> errors = result.getErrors();
            if (logger.isTraceEnabled()) {
                logger.debug((Object)("Found " + errors.size() + " validation errors in SAML response [" + response.getID() + "]: " + errors));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + errors.size() + " validation errors in SAML response [" + response.getID() + "]"));
            }
            Saml2Error first = errors.iterator().next();
            throw OpenSamlAuthenticationProvider.createAuthenticationException(first.getErrorCode(), first.getDescription(), null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Successfully processed SAML Response [" + response.getID() + "]"));
        }
    }

    private Saml2ResponseValidatorResult validateResponse(Saml2AuthenticationToken token, Response response) {
        ArrayList<Saml2Error> errors = new ArrayList<Saml2Error>();
        String issuer = response.getIssuer().getValue();
        if (response.isSigned()) {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            try {
                profileValidator.validate(response.getSignature());
            }
            catch (Exception ex) {
                errors.add(new Saml2Error("invalid_signature", "Invalid signature for SAML Response [" + response.getID() + "]: "));
            }
            try {
                CriteriaSet criteriaSet = new CriteriaSet();
                criteriaSet.add((Object)new EvaluableEntityIDCredentialCriterion(new EntityIdCriterion(issuer)));
                criteriaSet.add((Object)new EvaluableProtocolRoleDescriptorCriterion(new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")));
                criteriaSet.add((Object)new EvaluableUsageCredentialCriterion(new UsageCriterion(UsageType.SIGNING)));
                if (!((SignatureTrustEngine)this.signatureTrustEngineConverter.convert((Object)token)).validate((Object)response.getSignature(), criteriaSet)) {
                    errors.add(new Saml2Error("invalid_signature", "Invalid signature for SAML Response [" + response.getID() + "]"));
                }
            }
            catch (Exception ex) {
                errors.add(new Saml2Error("invalid_signature", "Invalid signature for SAML Response [" + response.getID() + "]: "));
            }
        }
        String destination = response.getDestination();
        String location = token.getRelyingPartyRegistration().getAssertionConsumerServiceLocation();
        if (StringUtils.hasText((String)destination) && !destination.equals(location)) {
            String message = "Invalid destination [" + destination + "] for SAML response [" + response.getID() + "]";
            errors.add(new Saml2Error("invalid_destination", message));
        }
        String assertingPartyEntityId = token.getRelyingPartyRegistration().getAssertingPartyDetails().getEntityId();
        if (!StringUtils.hasText((String)issuer) || !issuer.equals(assertingPartyEntityId)) {
            String message = String.format("Invalid issuer [%s] for SAML response [%s]", issuer, response.getID());
            errors.add(new Saml2Error("invalid_issuer", message));
        }
        return Saml2ResponseValidatorResult.failure(errors);
    }

    private List<Assertion> decryptAssertions(Decrypter decrypter, Response response) {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
            try {
                Assertion assertion = decrypter.decrypt(encryptedAssertion);
                assertions.add(assertion);
            }
            catch (DecryptionException ex) {
                throw OpenSamlAuthenticationProvider.createAuthenticationException("decryption_error", ex.getMessage(), (Exception)((Object)ex));
            }
        }
        response.getAssertions().addAll(assertions);
        return response.getAssertions();
    }

    private Saml2ResponseValidatorResult validateAssertions(Saml2AuthenticationToken token, Response response) {
        List assertions = response.getAssertions();
        if (assertions.isEmpty()) {
            throw OpenSamlAuthenticationProvider.createAuthenticationException("malformed_response_data", "No assertions found in response.", null);
        }
        Saml2ResponseValidatorResult result = Saml2ResponseValidatorResult.success();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating " + assertions.size() + " assertions"));
        }
        for (Assertion assertion : assertions) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Validating assertion " + assertion.getID()));
            }
            AssertionToken assertionToken = new AssertionToken(assertion, token);
            result = result.concat((Saml2ResponseValidatorResult)this.assertionSignatureValidator.convert((Object)assertionToken)).concat((Saml2ResponseValidatorResult)this.assertionValidator.convert((Object)assertionToken));
        }
        return result;
    }

    private void addValidationException(Map<String, Saml2AuthenticationException> exceptions, String code, String message, Exception cause) {
        exceptions.put(code, OpenSamlAuthenticationProvider.createAuthenticationException(code, message, cause));
    }

    private boolean isSigned(boolean responseSigned, List<Assertion> assertions) {
        if (responseSigned) {
            return true;
        }
        for (Assertion assertion : assertions) {
            if (assertion.isSigned()) continue;
            return false;
        }
        return true;
    }

    private NameID decryptPrincipal(Decrypter decrypter, Assertion assertion) {
        if (assertion.getSubject() == null) {
            return null;
        }
        if (assertion.getSubject().getEncryptedID() == null) {
            return assertion.getSubject().getNameID();
        }
        try {
            NameID nameId = (NameID)decrypter.decrypt(assertion.getSubject().getEncryptedID());
            assertion.getSubject().setNameID(nameId);
            return nameId;
        }
        catch (DecryptionException ex) {
            throw OpenSamlAuthenticationProvider.createAuthenticationException("decryption_error", ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private static Map<String, List<Object>> getAssertionAttributes(Assertion assertion) {
        LinkedHashMap<String, List<Object>> attributeMap = new LinkedHashMap<String, List<Object>>();
        for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                ArrayList<Object> attributeValues = new ArrayList<Object>();
                for (XMLObject xmlObject : attribute.getAttributeValues()) {
                    Object attributeValue = OpenSamlAuthenticationProvider.getXmlObjectValue(xmlObject);
                    if (attributeValue == null) continue;
                    attributeValues.add(attributeValue);
                }
                attributeMap.put(attribute.getName(), attributeValues);
            }
        }
        return attributeMap;
    }

    private static Object getXmlObjectValue(XMLObject xmlObject) {
        if (xmlObject instanceof XSAny) {
            return ((XSAny)xmlObject).getTextContent();
        }
        if (xmlObject instanceof XSString) {
            return ((XSString)xmlObject).getValue();
        }
        if (xmlObject instanceof XSInteger) {
            return ((XSInteger)xmlObject).getValue();
        }
        if (xmlObject instanceof XSURI) {
            return ((XSURI)xmlObject).getValue();
        }
        if (xmlObject instanceof XSBoolean) {
            XSBooleanValue xsBooleanValue = ((XSBoolean)xmlObject).getValue();
            return xsBooleanValue != null ? xsBooleanValue.getValue() : null;
        }
        if (xmlObject instanceof XSDateTime) {
            DateTime dateTime = ((XSDateTime)xmlObject).getValue();
            return dateTime != null ? Instant.ofEpochMilli(dateTime.getMillis()) : null;
        }
        return null;
    }

    private static Saml2AuthenticationException createAuthenticationException(String code, String message, Exception cause) {
        return new Saml2AuthenticationException(new Saml2Error(code, message), (Throwable)cause);
    }

    private static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator(String errorCode, Converter<AssertionToken, SAML20AssertionValidator> validatorConverter, Converter<AssertionToken, ValidationContext> contextConverter) {
        return assertionToken -> {
            Assertion assertion = ((AssertionToken)assertionToken).assertion;
            SAML20AssertionValidator validator = (SAML20AssertionValidator)validatorConverter.convert(assertionToken);
            ValidationContext context = (ValidationContext)contextConverter.convert(assertionToken);
            try {
                ValidationResult result = validator.validate(assertion, context);
                if (result == ValidationResult.VALID) {
                    return Saml2ResponseValidatorResult.success();
                }
            }
            catch (Exception ex) {
                String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), ex.getMessage());
                return Saml2ResponseValidatorResult.failure(new Saml2Error(errorCode, message));
            }
            String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), context.getValidationFailureMessage());
            return Saml2ResponseValidatorResult.failure(new Saml2Error(errorCode, message));
        };
    }

    private static ValidationContext createValidationContext(AssertionToken assertionToken, Consumer<Map<String, Object>> paramsConsumer) {
        String audience = assertionToken.token.getRelyingPartyRegistration().getEntityId();
        String recipient = assertionToken.token.getRelyingPartyRegistration().getAssertionConsumerServiceLocation();
        HashMap<String, Set<String>> params = new HashMap<String, Set<String>>();
        params.put("saml2.Conditions.ValidAudiences", Collections.singleton(audience));
        params.put("saml2.SubjectConfirmation.ValidRecipients", Collections.singleton(recipient));
        paramsConsumer.accept(params);
        return new ValidationContext(params);
    }

    static {
        OpenSamlInitializationService.initialize();
        logger = LogFactory.getLog(OpenSamlAuthenticationProvider.class);
    }

    public static class AssertionToken {
        private final Saml2AuthenticationToken token;
        private final Assertion assertion;

        AssertionToken(Assertion assertion, Saml2AuthenticationToken token) {
            this.token = token;
            this.assertion = assertion;
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    public static class ResponseToken {
        private final Saml2AuthenticationToken token;
        private final Response response;

        ResponseToken(Response response, Saml2AuthenticationToken token) {
            this.token = token;
            this.response = response;
        }

        public Response getResponse() {
            return this.response;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    private static class DecrypterConverter
    implements Converter<Saml2AuthenticationToken, Decrypter> {
        private final EncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver(Arrays.asList(new InlineEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver()));

        private DecrypterConverter() {
        }

        public Decrypter convert(Saml2AuthenticationToken token) {
            ArrayList<BasicX509Credential> credentials = new ArrayList<BasicX509Credential>();
            for (Saml2X509Credential key : token.getRelyingPartyRegistration().getDecryptionX509Credentials()) {
                BasicX509Credential cred = CredentialSupport.getSimpleCredential((X509Certificate)key.getCertificate(), (PrivateKey)key.getPrivateKey());
                credentials.add(cred);
            }
            CollectionKeyInfoCredentialResolver resolver = new CollectionKeyInfoCredentialResolver(credentials);
            Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, this.encryptedKeyResolver);
            decrypter.setRootInNewDocument(true);
            return decrypter;
        }
    }

    private static class SAML20AssertionValidators {
        private static final Collection<ConditionValidator> conditions = new ArrayList<ConditionValidator>();
        private static final Collection<SubjectConfirmationValidator> subjects = new ArrayList<SubjectConfirmationValidator>();
        private static final Collection<StatementValidator> statements = new ArrayList<StatementValidator>();
        private static final SignaturePrevalidator validator = new SAMLSignatureProfileValidator();
        private static final SAML20AssertionValidator attributeValidator;

        private SAML20AssertionValidators() {
        }

        static SAML20AssertionValidator createSignatureValidator(SignatureTrustEngine engine) {
            return new SAML20AssertionValidator(new ArrayList(), new ArrayList(), new ArrayList(), engine, validator){

                @Nonnull
                protected ValidationResult validateConditions(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }

                @Nonnull
                protected ValidationResult validateSubjectConfirmation(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }

                @Nonnull
                protected ValidationResult validateStatements(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }
            };
        }

        static {
            conditions.add((ConditionValidator)new AudienceRestrictionConditionValidator());
            conditions.add((ConditionValidator)new DelegationRestrictionConditionValidator());
            conditions.add(new ConditionValidator(){

                @Nonnull
                public QName getServicedCondition() {
                    return OneTimeUse.DEFAULT_ELEMENT_NAME;
                }

                @Nonnull
                public ValidationResult validate(Condition condition, Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }
            });
            subjects.add((SubjectConfirmationValidator)new BearerSubjectConfirmationValidator(){

                @Nonnull
                protected ValidationResult validateAddress(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context) {
                    return ValidationResult.VALID;
                }
            });
            attributeValidator = new SAML20AssertionValidator(conditions, subjects, statements, null, null){

                @Nonnull
                protected ValidationResult validateSignature(Assertion token, ValidationContext context) {
                    return ValidationResult.VALID;
                }
            };
        }
    }

    private static class SignatureTrustEngineConverter
    implements Converter<Saml2AuthenticationToken, SignatureTrustEngine> {
        private SignatureTrustEngineConverter() {
        }

        public SignatureTrustEngine convert(Saml2AuthenticationToken token) {
            HashSet<BasicX509Credential> credentials = new HashSet<BasicX509Credential>();
            Collection<Saml2X509Credential> keys = token.getRelyingPartyRegistration().getAssertingPartyDetails().getVerificationX509Credentials();
            for (Saml2X509Credential key : keys) {
                BasicX509Credential cred = new BasicX509Credential(key.getCertificate());
                cred.setUsageType(UsageType.SIGNING);
                cred.setEntityId(token.getRelyingPartyRegistration().getAssertingPartyDetails().getEntityId());
                credentials.add(cred);
            }
            CollectionCredentialResolver credentialsResolver = new CollectionCredentialResolver(credentials);
            return new ExplicitKeySignatureTrustEngine((CredentialResolver)credentialsResolver, DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        }
    }
}

