/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.joda.time.DateTime;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestMarshaller;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestContext;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2PostAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2RedirectAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2Utils;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenSamlAuthenticationRequestFactory
implements Saml2AuthenticationRequestFactory {
    private Clock clock = Clock.systemUTC();
    private AuthnRequestMarshaller marshaller;
    private AuthnRequestBuilder authnRequestBuilder;
    private IssuerBuilder issuerBuilder;
    private Converter<Saml2AuthenticationRequestContext, String> protocolBindingResolver = context -> {
        if (context == null) {
            return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
        }
        return context.getRelyingPartyRegistration().getAssertionConsumerServiceBinding().getUrn();
    };
    private Converter<Saml2AuthenticationRequestContext, AuthnRequest> authenticationRequestContextConverter = this::createAuthnRequest;

    public OpenSamlAuthenticationRequestFactory() {
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.marshaller = (AuthnRequestMarshaller)registry.getMarshallerFactory().getMarshaller(AuthnRequest.DEFAULT_ELEMENT_NAME);
        this.authnRequestBuilder = (AuthnRequestBuilder)registry.getBuilderFactory().getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        this.issuerBuilder = (IssuerBuilder)registry.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
    }

    @Override
    @Deprecated
    public String createAuthenticationRequest(Saml2AuthenticationRequest request) {
        AuthnRequest authnRequest = this.createAuthnRequest(request.getIssuer(), request.getDestination(), request.getAssertionConsumerServiceUrl(), (String)this.protocolBindingResolver.convert(null));
        for (org.springframework.security.saml2.credentials.Saml2X509Credential credential : request.getCredentials()) {
            if (!credential.isSigningCredential()) continue;
            X509Certificate certificate = credential.getCertificate();
            PrivateKey privateKey = credential.getPrivateKey();
            BasicX509Credential cred = CredentialSupport.getSimpleCredential((X509Certificate)certificate, (PrivateKey)privateKey);
            cred.setEntityId(request.getIssuer());
            cred.setUsageType(UsageType.SIGNING);
            SignatureSigningParameters parameters = new SignatureSigningParameters();
            parameters.setSigningCredential((Credential)cred);
            parameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            parameters.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
            parameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            return this.serialize(this.sign(authnRequest, parameters));
        }
        throw new IllegalArgumentException("No signing credential provided");
    }

    @Override
    public Saml2PostAuthenticationRequest createPostAuthenticationRequest(Saml2AuthenticationRequestContext context) {
        AuthnRequest authnRequest = (AuthnRequest)this.authenticationRequestContextConverter.convert((Object)context);
        String xml = context.getRelyingPartyRegistration().getAssertingPartyDetails().getWantAuthnRequestsSigned() ? this.serialize(this.sign(authnRequest, context.getRelyingPartyRegistration())) : this.serialize(authnRequest);
        return ((Saml2PostAuthenticationRequest.Builder)Saml2PostAuthenticationRequest.withAuthenticationRequestContext(context).samlRequest(Saml2Utils.samlEncode(xml.getBytes(StandardCharsets.UTF_8)))).build();
    }

    @Override
    public Saml2RedirectAuthenticationRequest createRedirectAuthenticationRequest(Saml2AuthenticationRequestContext context) {
        AuthnRequest authnRequest = (AuthnRequest)this.authenticationRequestContextConverter.convert((Object)context);
        String xml = this.serialize(authnRequest);
        Saml2RedirectAuthenticationRequest.Builder result = Saml2RedirectAuthenticationRequest.withAuthenticationRequestContext(context);
        String deflatedAndEncoded = Saml2Utils.samlEncode(Saml2Utils.samlDeflate(xml));
        ((Saml2RedirectAuthenticationRequest.Builder)result.samlRequest(deflatedAndEncoded)).relayState(context.getRelayState());
        if (context.getRelyingPartyRegistration().getAssertingPartyDetails().getWantAuthnRequestsSigned()) {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("SAMLRequest", deflatedAndEncoded);
            if (StringUtils.hasText((String)context.getRelayState())) {
                parameters.put("RelayState", context.getRelayState());
            }
            this.sign(parameters, context.getRelyingPartyRegistration());
            return result.sigAlg((String)parameters.get("SigAlg")).signature((String)parameters.get("Signature")).build();
        }
        return result.build();
    }

    private AuthnRequest createAuthnRequest(Saml2AuthenticationRequestContext context) {
        return this.createAuthnRequest(context.getIssuer(), context.getDestination(), context.getAssertionConsumerServiceUrl(), (String)this.protocolBindingResolver.convert((Object)context));
    }

    private AuthnRequest createAuthnRequest(String issuer, String destination, String assertionConsumerServiceUrl, String protocolBinding) {
        AuthnRequest auth = this.authnRequestBuilder.buildObject();
        auth.setID("ARQ" + UUID.randomUUID().toString().substring(1));
        auth.setIssueInstant(new DateTime(this.clock.millis()));
        auth.setForceAuthn(Boolean.FALSE);
        auth.setIsPassive(Boolean.FALSE);
        auth.setProtocolBinding(protocolBinding);
        Issuer iss = this.issuerBuilder.buildObject();
        iss.setValue(issuer);
        auth.setIssuer(iss);
        auth.setDestination(destination);
        auth.setAssertionConsumerServiceURL(assertionConsumerServiceUrl);
        return auth;
    }

    public void setAuthenticationRequestContextConverter(Converter<Saml2AuthenticationRequestContext, AuthnRequest> authenticationRequestContextConverter) {
        Assert.notNull(authenticationRequestContextConverter, (String)"authenticationRequestContextConverter cannot be null");
        this.authenticationRequestContextConverter = authenticationRequestContextConverter;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    @Deprecated
    public void setProtocolBinding(String protocolBinding) {
        boolean isAllowedBinding;
        boolean bl = isAllowedBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(protocolBinding) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(protocolBinding);
        if (!isAllowedBinding) {
            throw new IllegalArgumentException("Invalid protocol binding: " + protocolBinding);
        }
        this.protocolBindingResolver = context -> protocolBinding;
    }

    private AuthnRequest sign(AuthnRequest authnRequest, RelyingPartyRegistration relyingPartyRegistration) {
        SignatureSigningParameters parameters = this.resolveSigningParameters(relyingPartyRegistration);
        return this.sign(authnRequest, parameters);
    }

    private AuthnRequest sign(AuthnRequest authnRequest, SignatureSigningParameters parameters) {
        try {
            SignatureSupport.signObject((SignableXMLObject)authnRequest, (SignatureSigningParameters)parameters);
            return authnRequest;
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    private void sign(Map<String, String> components, RelyingPartyRegistration relyingPartyRegistration) {
        SignatureSigningParameters parameters = this.resolveSigningParameters(relyingPartyRegistration);
        this.sign(components, parameters);
    }

    private void sign(Map<String, String> components, SignatureSigningParameters parameters) {
        Credential credential = parameters.getSigningCredential();
        String algorithmUri = parameters.getSignatureAlgorithm();
        components.put("SigAlg", algorithmUri);
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
        for (Map.Entry<String, String> component : components.entrySet()) {
            builder.queryParam(component.getKey(), new Object[]{UriUtils.encode((String)component.getValue(), (Charset)StandardCharsets.ISO_8859_1)});
        }
        String queryString = builder.build(true).toString().substring(1);
        try {
            byte[] rawSignature = XMLSigningUtil.signWithURI((Credential)credential, (String)algorithmUri, (byte[])queryString.getBytes(StandardCharsets.UTF_8));
            String b64Signature = Saml2Utils.samlEncode(rawSignature);
            components.put("Signature", b64Signature);
        }
        catch (SecurityException ex) {
            throw new Saml2Exception(ex);
        }
    }

    private String serialize(AuthnRequest authnRequest) {
        try {
            Element element = this.marshaller.marshall((XMLObject)authnRequest);
            return SerializeSupport.nodeToString((Node)element);
        }
        catch (MarshallingException ex) {
            throw new Saml2Exception(ex);
        }
    }

    private SignatureSigningParameters resolveSigningParameters(RelyingPartyRegistration relyingPartyRegistration) {
        List<Credential> credentials = this.resolveSigningCredentials(relyingPartyRegistration);
        List<String> algorithms = Collections.singletonList("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        List<String> digests = Collections.singletonList("http://www.w3.org/2001/04/xmlenc#sha256");
        String canonicalization = "http://www.w3.org/2001/10/xml-exc-c14n#";
        SAMLMetadataSignatureSigningParametersResolver resolver = new SAMLMetadataSignatureSigningParametersResolver();
        CriteriaSet criteria = new CriteriaSet();
        BasicSignatureSigningConfiguration signingConfiguration = new BasicSignatureSigningConfiguration();
        signingConfiguration.setSigningCredentials(credentials);
        signingConfiguration.setSignatureAlgorithms(algorithms);
        signingConfiguration.setSignatureReferenceDigestMethods(digests);
        signingConfiguration.setSignatureCanonicalizationAlgorithm(canonicalization);
        criteria.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{signingConfiguration}));
        try {
            SignatureSigningParameters parameters = (SignatureSigningParameters)resolver.resolveSingle((Object)criteria);
            Assert.notNull((Object)parameters, (String)"Failed to resolve any signing credential");
            return parameters;
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    private List<Credential> resolveSigningCredentials(RelyingPartyRegistration relyingPartyRegistration) {
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        for (Saml2X509Credential x509Credential : relyingPartyRegistration.getSigningX509Credentials()) {
            X509Certificate certificate = x509Credential.getCertificate();
            PrivateKey privateKey = x509Credential.getPrivateKey();
            BasicX509Credential credential = CredentialSupport.getSimpleCredential((X509Certificate)certificate, (PrivateKey)privateKey);
            credential.setEntityId(relyingPartyRegistration.getEntityId());
            credential.setUsageType(UsageType.SIGNING);
            credentials.add((Credential)credential);
        }
        return credentials;
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

