/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResolver;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public final class Saml2MetadataFilter
extends OncePerRequestFilter {
    private final Converter<HttpServletRequest, RelyingPartyRegistration> relyingPartyRegistrationConverter;
    private final Saml2MetadataResolver saml2MetadataResolver;
    private RequestMatcher requestMatcher = new AntPathRequestMatcher("/saml2/service-provider-metadata/{registrationId}");

    public Saml2MetadataFilter(Converter<HttpServletRequest, RelyingPartyRegistration> relyingPartyRegistrationConverter, Saml2MetadataResolver saml2MetadataResolver) {
        this.relyingPartyRegistrationConverter = relyingPartyRegistrationConverter;
        this.saml2MetadataResolver = saml2MetadataResolver;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        RequestMatcher.MatchResult matcher = this.requestMatcher.matcher(request);
        if (!matcher.isMatch()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        RelyingPartyRegistration relyingPartyRegistration = (RelyingPartyRegistration)this.relyingPartyRegistrationConverter.convert((Object)request);
        if (relyingPartyRegistration == null) {
            response.setStatus(401);
            return;
        }
        String metadata = this.saml2MetadataResolver.resolve(relyingPartyRegistration);
        String registrationId = relyingPartyRegistration.getRegistrationId();
        this.writeMetadataToResponse(response, registrationId, metadata);
    }

    private void writeMetadataToResponse(HttpServletResponse response, String registrationId, String metadata) throws IOException {
        response.setContentType("application/xml");
        response.setHeader("Content-Disposition", "attachment; filename=\"saml-" + registrationId + "-metadata.xml\"");
        response.setContentLength(metadata.length());
        response.getWriter().write(metadata);
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }
}

