/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.AudienceRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.impl.BearerSubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.DelegationRestrictionConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.impl.ResponseUnmarshaller;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2ResponseValidatorResult;
import org.springframework.security.saml2.provider.service.authentication.DefaultSaml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlDecryptionUtils;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlVerificationUtils;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class OpenSaml4AuthenticationProvider
implements AuthenticationProvider {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ResponseUnmarshaller responseUnmarshaller;
    private final ParserPool parserPool;
    private final Converter<ResponseToken, Saml2ResponseValidatorResult> responseSignatureValidator = this.createDefaultResponseSignatureValidator();
    private Consumer<ResponseToken> responseElementsDecrypter = this.createDefaultResponseElementsDecrypter();
    private final Converter<ResponseToken, Saml2ResponseValidatorResult> responseValidator = this.createDefaultResponseValidator();
    private final Converter<AssertionToken, Saml2ResponseValidatorResult> assertionSignatureValidator = this.createDefaultAssertionSignatureValidator();
    private Consumer<AssertionToken> assertionElementsDecrypter = this.createDefaultAssertionElementsDecrypter();
    private Converter<AssertionToken, Saml2ResponseValidatorResult> assertionValidator = OpenSaml4AuthenticationProvider.createDefaultAssertionValidator();
    private Converter<ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter = OpenSaml4AuthenticationProvider.createDefaultResponseAuthenticationConverter();

    public OpenSaml4AuthenticationProvider() {
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.responseUnmarshaller = (ResponseUnmarshaller)registry.getUnmarshallerFactory().getUnmarshaller(Response.DEFAULT_ELEMENT_NAME);
        this.parserPool = registry.getParserPool();
    }

    public void setResponseElementsDecrypter(Consumer<ResponseToken> responseElementsDecrypter) {
        Assert.notNull(responseElementsDecrypter, (String)"responseElementsDecrypter cannot be null");
        this.responseElementsDecrypter = responseElementsDecrypter;
    }

    public void setAssertionValidator(Converter<AssertionToken, Saml2ResponseValidatorResult> assertionValidator) {
        Assert.notNull(assertionValidator, (String)"assertionValidator cannot be null");
        this.assertionValidator = assertionValidator;
    }

    public void setAssertionElementsDecrypter(Consumer<AssertionToken> assertionDecrypter) {
        Assert.notNull(assertionDecrypter, (String)"assertionDecrypter cannot be null");
        this.assertionElementsDecrypter = assertionDecrypter;
    }

    public void setResponseAuthenticationConverter(Converter<ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter) {
        Assert.notNull(responseAuthenticationConverter, (String)"responseAuthenticationConverter cannot be null");
        this.responseAuthenticationConverter = responseAuthenticationConverter;
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator() {
        return OpenSaml4AuthenticationProvider.createAssertionValidator("invalid_assertion", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> SAML20AssertionValidators.attributeValidator), (Converter<AssertionToken, ValidationContext>)((Converter)assertionToken -> OpenSaml4AuthenticationProvider.createValidationContext(assertionToken, params -> params.put("saml2.ClockSkew", Duration.ofMinutes(5L)))));
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator(Converter<AssertionToken, ValidationContext> contextConverter) {
        return OpenSaml4AuthenticationProvider.createAssertionValidator("invalid_assertion", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> SAML20AssertionValidators.attributeValidator), contextConverter);
    }

    public static Converter<ResponseToken, Saml2Authentication> createDefaultResponseAuthenticationConverter() {
        return responseToken -> {
            Response response = responseToken.response;
            Saml2AuthenticationToken token = responseToken.token;
            Assertion assertion = (Assertion)CollectionUtils.firstElement((List)response.getAssertions());
            String username = assertion.getSubject().getNameID().getValue();
            Map<String, List<Object>> attributes = OpenSaml4AuthenticationProvider.getAssertionAttributes(assertion);
            return new Saml2Authentication(new DefaultSaml2AuthenticatedPrincipal(username, attributes), token.getSaml2Response(), AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        };
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            Saml2AuthenticationToken token = (Saml2AuthenticationToken)authentication;
            String serializedResponse = token.getSaml2Response();
            Response response = this.parse(serializedResponse);
            this.process(token, response);
            return (Authentication)this.responseAuthenticationConverter.convert((Object)new ResponseToken(response, token));
        }
        catch (Saml2AuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw OpenSaml4AuthenticationProvider.createAuthenticationException("internal_validation_error", ex.getMessage(), ex);
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication != null && Saml2AuthenticationToken.class.isAssignableFrom(authentication);
    }

    private Response parse(String response) throws Saml2Exception, Saml2AuthenticationException {
        try {
            Document document = this.parserPool.parse((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8)));
            Element element = document.getDocumentElement();
            return (Response)this.responseUnmarshaller.unmarshall(element);
        }
        catch (Exception ex) {
            throw OpenSaml4AuthenticationProvider.createAuthenticationException("malformed_response_data", ex.getMessage(), ex);
        }
    }

    private void process(Saml2AuthenticationToken token, Response response) {
        String issuer = response.getIssuer().getValue();
        this.logger.debug((Object)LogMessage.format((String)"Processing SAML response from %s", (Object)issuer));
        boolean responseSigned = response.isSigned();
        ResponseToken responseToken = new ResponseToken(response, token);
        Saml2ResponseValidatorResult result = (Saml2ResponseValidatorResult)this.responseSignatureValidator.convert((Object)responseToken);
        if (responseSigned) {
            this.responseElementsDecrypter.accept(responseToken);
        }
        result = result.concat((Saml2ResponseValidatorResult)this.responseValidator.convert((Object)responseToken));
        boolean allAssertionsSigned = true;
        for (Assertion assertion : response.getAssertions()) {
            AssertionToken assertionToken = new AssertionToken(assertion, token);
            result = result.concat((Saml2ResponseValidatorResult)this.assertionSignatureValidator.convert((Object)assertionToken));
            boolean bl = allAssertionsSigned = allAssertionsSigned && assertion.isSigned();
            if (responseSigned || assertion.isSigned()) {
                this.assertionElementsDecrypter.accept(new AssertionToken(assertion, token));
            }
            result = result.concat((Saml2ResponseValidatorResult)this.assertionValidator.convert((Object)assertionToken));
        }
        if (!responseSigned && !allAssertionsSigned) {
            String description = "Either the response or one of the assertions is unsigned. Please either sign the response or all of the assertions.";
            throw OpenSaml4AuthenticationProvider.createAuthenticationException("invalid_signature", description, null);
        }
        Assertion firstAssertion = (Assertion)CollectionUtils.firstElement((List)response.getAssertions());
        if (!this.hasName(firstAssertion)) {
            Saml2Error error = new Saml2Error("subject_not_found", "Assertion [" + firstAssertion.getID() + "] is missing a subject");
            result = result.concat(error);
        }
        if (result.hasErrors()) {
            Collection<Saml2Error> errors = result.getErrors();
            if (this.logger.isTraceEnabled()) {
                this.logger.debug((Object)("Found " + errors.size() + " validation errors in SAML response [" + response.getID() + "]: " + errors));
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found " + errors.size() + " validation errors in SAML response [" + response.getID() + "]"));
            }
            Saml2Error first = errors.iterator().next();
            throw OpenSaml4AuthenticationProvider.createAuthenticationException(first.getErrorCode(), first.getDescription(), null);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Successfully processed SAML Response [" + response.getID() + "]"));
        }
    }

    private Converter<ResponseToken, Saml2ResponseValidatorResult> createDefaultResponseSignatureValidator() {
        return responseToken -> {
            Response response = responseToken.getResponse();
            RelyingPartyRegistration registration = responseToken.getToken().getRelyingPartyRegistration();
            if (response.isSigned()) {
                return OpenSamlVerificationUtils.verifySignature((StatusResponseType)response, registration).post(response.getSignature());
            }
            return Saml2ResponseValidatorResult.success();
        };
    }

    private Consumer<ResponseToken> createDefaultResponseElementsDecrypter() {
        return responseToken -> {
            Response response = responseToken.getResponse();
            RelyingPartyRegistration registration = responseToken.getToken().getRelyingPartyRegistration();
            try {
                OpenSamlDecryptionUtils.decryptResponseElements(response, registration);
            }
            catch (Exception ex) {
                throw OpenSaml4AuthenticationProvider.createAuthenticationException("decryption_error", ex.getMessage(), ex);
            }
        };
    }

    private Converter<ResponseToken, Saml2ResponseValidatorResult> createDefaultResponseValidator() {
        return responseToken -> {
            Response response = responseToken.getResponse();
            Saml2AuthenticationToken token = responseToken.getToken();
            Saml2ResponseValidatorResult result = Saml2ResponseValidatorResult.success();
            String statusCode = this.getStatusCode(response);
            if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
                String message = String.format("Invalid status [%s] for SAML response [%s]", statusCode, response.getID());
                result = result.concat(new Saml2Error("invalid_response", message));
            }
            String issuer = response.getIssuer().getValue();
            String destination = response.getDestination();
            String location = token.getRelyingPartyRegistration().getAssertionConsumerServiceLocation();
            if (StringUtils.hasText((String)destination) && !destination.equals(location)) {
                String message = "Invalid destination [" + destination + "] for SAML response [" + response.getID() + "]";
                result = result.concat(new Saml2Error("invalid_destination", message));
            }
            String assertingPartyEntityId = token.getRelyingPartyRegistration().getAssertingPartyDetails().getEntityId();
            if (!StringUtils.hasText((String)issuer) || !issuer.equals(assertingPartyEntityId)) {
                String message = String.format("Invalid issuer [%s] for SAML response [%s]", issuer, response.getID());
                result = result.concat(new Saml2Error("invalid_issuer", message));
            }
            if (response.getAssertions().isEmpty()) {
                throw OpenSaml4AuthenticationProvider.createAuthenticationException("malformed_response_data", "No assertions found in response.", null);
            }
            return result;
        };
    }

    private String getStatusCode(Response response) {
        if (response.getStatus() == null) {
            return "urn:oasis:names:tc:SAML:2.0:status:Success";
        }
        if (response.getStatus().getStatusCode() == null) {
            return "urn:oasis:names:tc:SAML:2.0:status:Success";
        }
        return response.getStatus().getStatusCode().getValue();
    }

    private Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionSignatureValidator() {
        return OpenSaml4AuthenticationProvider.createAssertionValidator("invalid_signature", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> {
            RelyingPartyRegistration registration = assertionToken.getToken().getRelyingPartyRegistration();
            SignatureTrustEngine engine = OpenSamlVerificationUtils.trustEngine(registration);
            return SAML20AssertionValidators.createSignatureValidator(engine);
        }), (Converter<AssertionToken, ValidationContext>)((Converter)assertionToken -> new ValidationContext(Collections.singletonMap("saml2.SignatureRequired", false))));
    }

    private Consumer<AssertionToken> createDefaultAssertionElementsDecrypter() {
        return assertionToken -> {
            Assertion assertion = assertionToken.getAssertion();
            RelyingPartyRegistration registration = assertionToken.getToken().getRelyingPartyRegistration();
            try {
                OpenSamlDecryptionUtils.decryptAssertionElements(assertion, registration);
            }
            catch (Exception ex) {
                throw OpenSaml4AuthenticationProvider.createAuthenticationException("decryption_error", ex.getMessage(), ex);
            }
        };
    }

    private boolean hasName(Assertion assertion) {
        if (assertion == null) {
            return false;
        }
        if (assertion.getSubject() == null) {
            return false;
        }
        if (assertion.getSubject().getNameID() == null) {
            return false;
        }
        return assertion.getSubject().getNameID().getValue() != null;
    }

    private static Map<String, List<Object>> getAssertionAttributes(Assertion assertion) {
        LinkedHashMap<String, List<Object>> attributeMap = new LinkedHashMap<String, List<Object>>();
        for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                ArrayList<Object> attributeValues = new ArrayList<Object>();
                for (XMLObject xmlObject : attribute.getAttributeValues()) {
                    Object attributeValue = OpenSaml4AuthenticationProvider.getXmlObjectValue(xmlObject);
                    if (attributeValue == null) continue;
                    attributeValues.add(attributeValue);
                }
                attributeMap.put(attribute.getName(), attributeValues);
            }
        }
        return attributeMap;
    }

    private static Object getXmlObjectValue(XMLObject xmlObject) {
        if (xmlObject instanceof XSAny) {
            return ((XSAny)xmlObject).getTextContent();
        }
        if (xmlObject instanceof XSString) {
            return ((XSString)xmlObject).getValue();
        }
        if (xmlObject instanceof XSInteger) {
            return ((XSInteger)xmlObject).getValue();
        }
        if (xmlObject instanceof XSURI) {
            return ((XSURI)xmlObject).getURI();
        }
        if (xmlObject instanceof XSBoolean) {
            XSBooleanValue xsBooleanValue = ((XSBoolean)xmlObject).getValue();
            return xsBooleanValue != null ? xsBooleanValue.getValue() : null;
        }
        if (xmlObject instanceof XSDateTime) {
            return ((XSDateTime)xmlObject).getValue();
        }
        return null;
    }

    private static Saml2AuthenticationException createAuthenticationException(String code, String message, Exception cause) {
        return new Saml2AuthenticationException(new Saml2Error(code, message), (Throwable)cause);
    }

    private static Converter<AssertionToken, Saml2ResponseValidatorResult> createAssertionValidator(String errorCode, Converter<AssertionToken, SAML20AssertionValidator> validatorConverter, Converter<AssertionToken, ValidationContext> contextConverter) {
        return assertionToken -> {
            Assertion assertion = assertionToken.assertion;
            SAML20AssertionValidator validator = (SAML20AssertionValidator)validatorConverter.convert(assertionToken);
            ValidationContext context = (ValidationContext)contextConverter.convert(assertionToken);
            try {
                ValidationResult result = validator.validate(assertion, context);
                if (result == ValidationResult.VALID) {
                    return Saml2ResponseValidatorResult.success();
                }
            }
            catch (Exception ex) {
                String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), ex.getMessage());
                return Saml2ResponseValidatorResult.failure(new Saml2Error(errorCode, message));
            }
            String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), context.getValidationFailureMessage());
            return Saml2ResponseValidatorResult.failure(new Saml2Error(errorCode, message));
        };
    }

    private static ValidationContext createValidationContext(AssertionToken assertionToken, Consumer<Map<String, Object>> paramsConsumer) {
        String audience = assertionToken.token.getRelyingPartyRegistration().getEntityId();
        String recipient = assertionToken.token.getRelyingPartyRegistration().getAssertionConsumerServiceLocation();
        HashMap<String, Set<String>> params = new HashMap<String, Set<String>>();
        params.put("saml2.Conditions.ValidAudiences", Collections.singleton(audience));
        params.put("saml2.SubjectConfirmation.ValidRecipients", Collections.singleton(recipient));
        paramsConsumer.accept(params);
        return new ValidationContext(params);
    }

    static {
        OpenSamlInitializationService.initialize();
    }

    public static class AssertionToken {
        private final Saml2AuthenticationToken token;
        private final Assertion assertion;

        AssertionToken(Assertion assertion, Saml2AuthenticationToken token) {
            this.token = token;
            this.assertion = assertion;
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    public static class ResponseToken {
        private final Saml2AuthenticationToken token;
        private final Response response;

        ResponseToken(Response response, Saml2AuthenticationToken token) {
            this.token = token;
            this.response = response;
        }

        public Response getResponse() {
            return this.response;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    private static class SAML20AssertionValidators {
        private static final Collection<ConditionValidator> conditions = new ArrayList<ConditionValidator>();
        private static final Collection<SubjectConfirmationValidator> subjects = new ArrayList<SubjectConfirmationValidator>();
        private static final Collection<StatementValidator> statements = new ArrayList<StatementValidator>();
        private static final SignaturePrevalidator validator = new SAMLSignatureProfileValidator();
        private static final SAML20AssertionValidator attributeValidator;

        private SAML20AssertionValidators() {
        }

        static SAML20AssertionValidator createSignatureValidator(SignatureTrustEngine engine) {
            return new SAML20AssertionValidator(new ArrayList(), new ArrayList(), new ArrayList(), null, engine, validator){

                @Nonnull
                protected ValidationResult validateConditions(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }

                @Nonnull
                protected ValidationResult validateSubjectConfirmation(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }

                @Nonnull
                protected ValidationResult validateStatements(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }
            };
        }

        static {
            conditions.add((ConditionValidator)new AudienceRestrictionConditionValidator());
            conditions.add((ConditionValidator)new DelegationRestrictionConditionValidator());
            conditions.add(new ConditionValidator(){

                @Nonnull
                public QName getServicedCondition() {
                    return OneTimeUse.DEFAULT_ELEMENT_NAME;
                }

                @Nonnull
                public ValidationResult validate(Condition condition, Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }
            });
            subjects.add((SubjectConfirmationValidator)new BearerSubjectConfirmationValidator(){

                protected ValidationResult validateAddress(SubjectConfirmation confirmation, Assertion assertion, ValidationContext context, boolean required) {
                    return ValidationResult.VALID;
                }

                protected ValidationResult validateInResponseTo(SubjectConfirmation confirmation, Assertion assertion, ValidationContext context, boolean required) {
                    return ValidationResult.VALID;
                }
            });
            attributeValidator = new SAML20AssertionValidator(conditions, subjects, statements, null, null, null){

                @Nonnull
                protected ValidationResult validateSignature(Assertion token, ValidationContext context) {
                    return ValidationResult.VALID;
                }
            };
        }
    }
}

