/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Function;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.springframework.http.HttpMethod;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.Assert;

public final class Saml2AuthenticationTokenConverter
implements AuthenticationConverter {
    private static final Base64.Decoder BASE64 = Base64.getMimeDecoder();
    private static final Base64Checker BASE_64_CHECKER = new Base64Checker();
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
    private Function<HttpServletRequest, AbstractSaml2AuthenticationRequest> loader;

    public Saml2AuthenticationTokenConverter(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        Assert.notNull((Object)relyingPartyRegistrationResolver, (String)"relyingPartyRegistrationResolver cannot be null");
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        this.loader = new HttpSessionSaml2AuthenticationRequestRepository()::loadAuthenticationRequest;
    }

    public Saml2AuthenticationToken convert(HttpServletRequest request) {
        AbstractSaml2AuthenticationRequest authenticationRequest = this.loadAuthenticationRequest(request);
        String relyingPartyRegistrationId = authenticationRequest != null ? authenticationRequest.getRelyingPartyRegistrationId() : null;
        RelyingPartyRegistration relyingPartyRegistration = this.relyingPartyRegistrationResolver.resolve(request, relyingPartyRegistrationId);
        if (relyingPartyRegistration == null) {
            return null;
        }
        String saml2Response = request.getParameter("SAMLResponse");
        if (saml2Response == null) {
            return null;
        }
        byte[] b = this.samlDecode(saml2Response);
        saml2Response = this.inflateIfRequired(request, b);
        return new Saml2AuthenticationToken(relyingPartyRegistration, saml2Response, authenticationRequest);
    }

    public void setAuthenticationRequestRepository(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        Assert.notNull(authenticationRequestRepository, (String)"authenticationRequestRepository cannot be null");
        this.loader = authenticationRequestRepository::loadAuthenticationRequest;
    }

    private AbstractSaml2AuthenticationRequest loadAuthenticationRequest(HttpServletRequest request) {
        return this.loader.apply(request);
    }

    private String inflateIfRequired(HttpServletRequest request, byte[] b) {
        if (HttpMethod.GET.matches(request.getMethod())) {
            return this.samlInflate(b);
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    private byte[] samlDecode(String base64EncodedPayload) {
        try {
            BASE_64_CHECKER.checkAcceptable(base64EncodedPayload);
            return BASE64.decode(base64EncodedPayload);
        }
        catch (Exception ex) {
            throw new Saml2AuthenticationException(new Saml2Error("invalid_response", "Failed to decode SAMLResponse"), ex);
        }
    }

    private String samlInflate(byte[] b) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InflaterOutputStream inflaterOutputStream = new InflaterOutputStream(out, new Inflater(true));
            inflaterOutputStream.write(b);
            inflaterOutputStream.finish();
            return out.toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            throw new Saml2AuthenticationException(new Saml2Error("invalid_response", "Unable to inflate string"), ex);
        }
    }

    static class Base64Checker {
        private static final int[] values = Base64Checker.genValueMapping();

        Base64Checker() {
        }

        private static int[] genValueMapping() {
            byte[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(StandardCharsets.ISO_8859_1);
            int[] values = new int[256];
            Arrays.fill(values, -1);
            for (int i = 0; i < alphabet.length; ++i) {
                values[alphabet[i] & 0xFF] = i;
            }
            return values;
        }

        boolean isAcceptable(String s) {
            int goodChars = 0;
            int lastGoodCharVal = -1;
            for (int i = 0; i < s.length(); ++i) {
                int val = values[0xFF & s.charAt(i)];
                if (val == -1) continue;
                lastGoodCharVal = val;
                ++goodChars;
            }
            switch (goodChars % 4) {
                case 0: {
                    return true;
                }
                case 2: {
                    return (lastGoodCharVal & 0xF) == 0;
                }
                case 3: {
                    return (lastGoodCharVal & 3) == 0;
                }
            }
            return false;
        }

        void checkAcceptable(String ins) {
            if (!this.isAcceptable(ins)) {
                throw new IllegalArgumentException("Unaccepted Encoding");
            }
        }
    }
}

