/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.BaseOpenSamlAuthenticationTokenConverter;
import org.springframework.security.saml2.provider.service.web.OpenSaml5Template;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OpenSaml5AuthenticationTokenConverter
implements AuthenticationConverter {
    private final BaseOpenSamlAuthenticationTokenConverter delegate;

    public OpenSaml5AuthenticationTokenConverter(RelyingPartyRegistrationRepository registrations) {
        Assert.notNull((Object)registrations, (String)"relyingPartyRegistrationRepository cannot be null");
        this.delegate = new BaseOpenSamlAuthenticationTokenConverter(registrations, new OpenSaml5Template());
    }

    public Saml2AuthenticationToken convert(HttpServletRequest request) {
        return this.delegate.convert(request);
    }

    public void setAuthenticationRequestRepository(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        Assert.notNull(authenticationRequestRepository, (String)"authenticationRequestRepository cannot be null");
        this.delegate.setAuthenticationRequestRepository(authenticationRequestRepository);
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.delegate.setRequestMatcher(requestMatcher);
    }
}

