/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.reactive.server;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.web.DefaultReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.reactive.result.method.annotation.OAuth2AuthorizedClientArgumentResolver;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.WebSessionServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.web.server.csrf.CsrfWebFilter;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.reactive.server.MockServerConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public final class SecurityMockServerConfigurers {
    private SecurityMockServerConfigurers() {
    }

    public static MockServerConfigurer springSecurity() {
        return new MockServerConfigurer(){

            public void beforeServerCreated(WebHttpHandlerBuilder builder) {
                builder.filters(filters -> filters.add(0, new MutatorFilter()));
            }
        };
    }

    public static <T extends WebTestClientConfigurer & MockServerConfigurer> T mockAuthentication(Authentication authentication) {
        return (T)new MutatorWebTestClientConfigurer(() -> Mono.just((Object)authentication).map(SecurityContextImpl::new));
    }

    public static <T extends WebTestClientConfigurer & MockServerConfigurer> T mockUser(UserDetails userDetails) {
        return SecurityMockServerConfigurers.mockAuthentication((Authentication)UsernamePasswordAuthenticationToken.authenticated((Object)userDetails, (Object)userDetails.getPassword(), (Collection)userDetails.getAuthorities()));
    }

    public static UserExchangeMutator mockUser() {
        return SecurityMockServerConfigurers.mockUser("user");
    }

    public static UserExchangeMutator mockUser(String username) {
        return new UserExchangeMutator(username);
    }

    public static JwtMutator mockJwt() {
        return new JwtMutator();
    }

    public static OpaqueTokenMutator mockOpaqueToken() {
        return new OpaqueTokenMutator();
    }

    public static OAuth2LoginMutator mockOAuth2Login() {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "access-token", null, null, Collections.singleton("read"));
        return new OAuth2LoginMutator(accessToken);
    }

    public static OidcLoginMutator mockOidcLogin() {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "access-token", null, null, Collections.singleton("read"));
        return new OidcLoginMutator(accessToken);
    }

    public static OAuth2ClientMutator mockOAuth2Client() {
        return new OAuth2ClientMutator();
    }

    public static OAuth2ClientMutator mockOAuth2Client(String registrationId) {
        return new OAuth2ClientMutator(registrationId);
    }

    public static CsrfMutator csrf() {
        return new CsrfMutator();
    }

    private static final class MutatorWebTestClientConfigurer
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private final Supplier<Mono<SecurityContext>> context;

        private MutatorWebTestClientConfigurer(Supplier<Mono<SecurityContext>> context) {
            this.context = context;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            builder.filters(this.addSetupMutatorFilter());
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder webHttpHandlerBuilder, @Nullable ClientHttpConnector clientHttpConnector) {
            webHttpHandlerBuilder.filters(this.addSetupMutatorFilter());
        }

        private Consumer<List<WebFilter>> addSetupMutatorFilter() {
            return filters -> filters.add(0, new SetupMutatorFilter(this.context));
        }
    }

    public static final class UserExchangeMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private final User.UserBuilder userBuilder;

        private UserExchangeMutator(String username) {
            this.userBuilder = User.withUsername((String)username);
            this.password("password");
            this.roles("USER");
        }

        public UserExchangeMutator password(String password) {
            this.userBuilder.password(password);
            return this;
        }

        public UserExchangeMutator roles(String ... roles) {
            this.userBuilder.roles(roles);
            return this;
        }

        public UserExchangeMutator authorities(GrantedAuthority ... authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator authorities(Collection<? extends GrantedAuthority> authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator authorities(String ... authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator accountExpired(boolean accountExpired) {
            this.userBuilder.accountExpired(accountExpired);
            return this;
        }

        public UserExchangeMutator accountLocked(boolean accountLocked) {
            this.userBuilder.accountLocked(accountLocked);
            return this;
        }

        public UserExchangeMutator credentialsExpired(boolean credentialsExpired) {
            this.userBuilder.credentialsExpired(credentialsExpired);
            return this;
        }

        public UserExchangeMutator disabled(boolean disabled) {
            this.userBuilder.disabled(disabled);
            return this;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            ((MockServerConfigurer)this.configurer()).beforeServerCreated(builder);
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
            ((MockServerConfigurer)this.configurer()).afterConfigureAdded(serverSpec);
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder webHttpHandlerBuilder, @Nullable ClientHttpConnector clientHttpConnector) {
            this.configurer().afterConfigurerAdded(builder, webHttpHandlerBuilder, clientHttpConnector);
        }

        private <T extends WebTestClientConfigurer & MockServerConfigurer> T configurer() {
            return SecurityMockServerConfigurers.mockUser(this.userBuilder.build());
        }
    }

    public static final class JwtMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private Jwt jwt;
        private Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter = new JwtGrantedAuthoritiesConverter();

        private JwtMutator() {
            this.jwt((Jwt.Builder jwt) -> {});
        }

        public JwtMutator jwt(Consumer<Jwt.Builder> jwtBuilderConsumer) {
            Jwt.Builder jwtBuilder = Jwt.withTokenValue((String)"token").header("alg", (Object)"none").claim("sub", (Object)"user").claim("scope", (Object)"read");
            jwtBuilderConsumer.accept(jwtBuilder);
            this.jwt = jwtBuilder.build();
            return this;
        }

        public JwtMutator jwt(Jwt jwt) {
            this.jwt = jwt;
            return this;
        }

        public JwtMutator authorities(Collection<GrantedAuthority> authorities) {
            Assert.notNull(authorities, (String)"authorities cannot be null");
            this.authoritiesConverter = jwt -> authorities;
            return this;
        }

        public JwtMutator authorities(GrantedAuthority ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.authoritiesConverter = jwt -> Arrays.asList(authorities);
            return this;
        }

        public JwtMutator authorities(Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter) {
            Assert.notNull(authoritiesConverter, (String)"authoritiesConverter cannot be null");
            this.authoritiesConverter = authoritiesConverter;
            return this;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            ((MockServerConfigurer)this.configurer()).beforeServerCreated(builder);
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
            ((MockServerConfigurer)this.configurer()).afterConfigureAdded(serverSpec);
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
            httpHandlerBuilder.filter(new WebFilter[]{(exchange, chain) -> {
                CsrfWebFilter.skipExchange((ServerWebExchange)exchange);
                return chain.filter(exchange);
            }});
            this.configurer().afterConfigurerAdded(builder, httpHandlerBuilder, connector);
        }

        private <T extends WebTestClientConfigurer & MockServerConfigurer> T configurer() {
            return SecurityMockServerConfigurers.mockAuthentication((Authentication)new JwtAuthenticationToken(this.jwt, (Collection)this.authoritiesConverter.convert((Object)this.jwt)));
        }
    }

    public static final class OpaqueTokenMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private Supplier<Map<String, Object>> attributes = this::defaultAttributes;
        private Supplier<Collection<GrantedAuthority>> authorities = this::defaultAuthorities;
        private Supplier<OAuth2AuthenticatedPrincipal> principal = this::defaultPrincipal;

        private OpaqueTokenMutator() {
        }

        public OpaqueTokenMutator attributes(Consumer<Map<String, Object>> attributesConsumer) {
            Assert.notNull(attributesConsumer, (String)"attributesConsumer cannot be null");
            this.attributes = () -> {
                Map<String, Object> attributes = this.defaultAttributes();
                attributesConsumer.accept(attributes);
                return attributes;
            };
            this.principal = this::defaultPrincipal;
            return this;
        }

        public OpaqueTokenMutator authorities(Collection<GrantedAuthority> authorities) {
            Assert.notNull(authorities, (String)"authorities cannot be null");
            this.authorities = () -> authorities;
            this.principal = this::defaultPrincipal;
            return this;
        }

        public OpaqueTokenMutator authorities(GrantedAuthority ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.authorities = () -> Arrays.asList(authorities);
            this.principal = this::defaultPrincipal;
            return this;
        }

        public OpaqueTokenMutator principal(OAuth2AuthenticatedPrincipal principal) {
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.principal = () -> principal;
            return this;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            ((MockServerConfigurer)this.configurer()).beforeServerCreated(builder);
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
            ((MockServerConfigurer)this.configurer()).afterConfigureAdded(serverSpec);
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
            httpHandlerBuilder.filter(new WebFilter[]{(exchange, chain) -> {
                CsrfWebFilter.skipExchange((ServerWebExchange)exchange);
                return chain.filter(exchange);
            }});
            this.configurer().afterConfigurerAdded(builder, httpHandlerBuilder, connector);
        }

        private <T extends WebTestClientConfigurer & MockServerConfigurer> T configurer() {
            OAuth2AuthenticatedPrincipal principal = this.principal.get();
            OAuth2AccessToken accessToken = this.getOAuth2AccessToken(principal);
            BearerTokenAuthentication token = new BearerTokenAuthentication(principal, accessToken, principal.getAuthorities());
            return SecurityMockServerConfigurers.mockAuthentication((Authentication)token);
        }

        private Map<String, Object> defaultAttributes() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("sub", "user");
            attributes.put("scope", "read");
            return attributes;
        }

        private Collection<GrantedAuthority> defaultAuthorities() {
            Map<String, Object> attributes = this.attributes.get();
            Object scope = attributes.get("scope");
            if (scope == null) {
                return Collections.emptyList();
            }
            if (scope instanceof Collection) {
                return this.getAuthorities((Collection)scope);
            }
            String scopes = scope.toString();
            if (!StringUtils.hasText((String)scopes)) {
                return Collections.emptyList();
            }
            return this.getAuthorities(Arrays.asList(scopes.split(" ")));
        }

        private OAuth2AuthenticatedPrincipal defaultPrincipal() {
            return new OAuth2IntrospectionAuthenticatedPrincipal(this.attributes.get(), this.authorities.get());
        }

        private Collection<GrantedAuthority> getAuthorities(Collection<?> scopes) {
            return scopes.stream().map(scope -> new SimpleGrantedAuthority("SCOPE_" + scope)).collect(Collectors.toList());
        }

        private OAuth2AccessToken getOAuth2AccessToken(OAuth2AuthenticatedPrincipal principal) {
            Instant expiresAt = this.getInstant(principal.getAttributes(), "exp");
            Instant issuedAt = this.getInstant(principal.getAttributes(), "iat");
            return new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "token", issuedAt, expiresAt);
        }

        private Instant getInstant(Map<String, Object> attributes, String name) {
            Object value = attributes.get(name);
            if (value == null) {
                return null;
            }
            if (value instanceof Instant) {
                return (Instant)value;
            }
            throw new IllegalArgumentException(name + " attribute must be of type Instant");
        }
    }

    public static final class OAuth2LoginMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private final String nameAttributeKey = "sub";
        private ClientRegistration clientRegistration;
        private OAuth2AccessToken accessToken;
        private Supplier<Collection<GrantedAuthority>> authorities = this::defaultAuthorities;
        private Supplier<Map<String, Object>> attributes = this::defaultAttributes;
        private Supplier<OAuth2User> oauth2User = this::defaultPrincipal;

        private OAuth2LoginMutator(OAuth2AccessToken accessToken) {
            this.accessToken = accessToken;
            this.clientRegistration = this.clientRegistrationBuilder().build();
        }

        public OAuth2LoginMutator authorities(Collection<GrantedAuthority> authorities) {
            Assert.notNull(authorities, (String)"authorities cannot be null");
            this.authorities = () -> authorities;
            this.oauth2User = this::defaultPrincipal;
            return this;
        }

        public OAuth2LoginMutator authorities(GrantedAuthority ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.authorities = () -> Arrays.asList(authorities);
            this.oauth2User = this::defaultPrincipal;
            return this;
        }

        public OAuth2LoginMutator attributes(Consumer<Map<String, Object>> attributesConsumer) {
            Assert.notNull(attributesConsumer, (String)"attributesConsumer cannot be null");
            this.attributes = () -> {
                Map<String, Object> attributes = this.defaultAttributes();
                attributesConsumer.accept(attributes);
                return attributes;
            };
            this.oauth2User = this::defaultPrincipal;
            return this;
        }

        public OAuth2LoginMutator oauth2User(OAuth2User oauth2User) {
            this.oauth2User = () -> oauth2User;
            return this;
        }

        public OAuth2LoginMutator clientRegistration(ClientRegistration clientRegistration) {
            this.clientRegistration = clientRegistration;
            return this;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            OAuth2AuthenticationToken token = this.getToken();
            SecurityMockServerConfigurers.mockOAuth2Client().accessToken(this.accessToken).clientRegistration(this.clientRegistration).principalName(token.getPrincipal().getName()).beforeServerCreated(builder);
            ((MockServerConfigurer)SecurityMockServerConfigurers.mockAuthentication((Authentication)token)).beforeServerCreated(builder);
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
            OAuth2AuthenticationToken token = this.getToken();
            SecurityMockServerConfigurers.mockOAuth2Client().accessToken(this.accessToken).clientRegistration(this.clientRegistration).principalName(token.getPrincipal().getName()).afterConfigureAdded(serverSpec);
            ((MockServerConfigurer)SecurityMockServerConfigurers.mockAuthentication((Authentication)token)).afterConfigureAdded(serverSpec);
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
            OAuth2AuthenticationToken token = this.getToken();
            SecurityMockServerConfigurers.mockOAuth2Client().accessToken(this.accessToken).clientRegistration(this.clientRegistration).principalName(token.getPrincipal().getName()).afterConfigurerAdded(builder, httpHandlerBuilder, connector);
            SecurityMockServerConfigurers.mockAuthentication((Authentication)token).afterConfigurerAdded(builder, httpHandlerBuilder, connector);
        }

        private OAuth2AuthenticationToken getToken() {
            OAuth2User oauth2User = this.oauth2User.get();
            return new OAuth2AuthenticationToken(oauth2User, oauth2User.getAuthorities(), this.clientRegistration.getRegistrationId());
        }

        private ClientRegistration.Builder clientRegistrationBuilder() {
            return ClientRegistration.withRegistrationId((String)"test").authorizationGrantType(AuthorizationGrantType.PASSWORD).clientId("test-client").tokenUri("https://token-uri.example.org");
        }

        private Collection<GrantedAuthority> defaultAuthorities() {
            LinkedHashSet<GrantedAuthority> authorities = new LinkedHashSet<GrantedAuthority>();
            authorities.add((GrantedAuthority)new OAuth2UserAuthority(this.attributes.get()));
            for (String authority : this.accessToken.getScopes()) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("SCOPE_" + authority));
            }
            return authorities;
        }

        private Map<String, Object> defaultAttributes() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(this.nameAttributeKey, "user");
            return attributes;
        }

        private OAuth2User defaultPrincipal() {
            return new DefaultOAuth2User(this.authorities.get(), this.attributes.get(), this.nameAttributeKey);
        }
    }

    public static final class OidcLoginMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private ClientRegistration clientRegistration;
        private OAuth2AccessToken accessToken;
        private OidcIdToken idToken;
        private OidcUserInfo userInfo;
        private Supplier<OidcUser> oidcUser = this::defaultPrincipal;
        private Collection<GrantedAuthority> authorities;

        private OidcLoginMutator(OAuth2AccessToken accessToken) {
            this.accessToken = accessToken;
            this.clientRegistration = this.clientRegistrationBuilder().build();
        }

        public OidcLoginMutator authorities(Collection<GrantedAuthority> authorities) {
            Assert.notNull(authorities, (String)"authorities cannot be null");
            this.authorities = authorities;
            this.oidcUser = this::defaultPrincipal;
            return this;
        }

        public OidcLoginMutator authorities(GrantedAuthority ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.authorities = Arrays.asList(authorities);
            this.oidcUser = this::defaultPrincipal;
            return this;
        }

        public OidcLoginMutator idToken(Consumer<OidcIdToken.Builder> idTokenBuilderConsumer) {
            OidcIdToken.Builder builder = OidcIdToken.withTokenValue((String)"id-token");
            builder.subject("user");
            idTokenBuilderConsumer.accept(builder);
            this.idToken = builder.build();
            this.oidcUser = this::defaultPrincipal;
            return this;
        }

        public OidcLoginMutator userInfoToken(Consumer<OidcUserInfo.Builder> userInfoBuilderConsumer) {
            OidcUserInfo.Builder builder = OidcUserInfo.builder();
            userInfoBuilderConsumer.accept(builder);
            this.userInfo = builder.build();
            this.oidcUser = this::defaultPrincipal;
            return this;
        }

        public OidcLoginMutator oidcUser(OidcUser oidcUser) {
            this.oidcUser = () -> oidcUser;
            return this;
        }

        public OidcLoginMutator clientRegistration(ClientRegistration clientRegistration) {
            this.clientRegistration = clientRegistration;
            return this;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            OAuth2AuthenticationToken token = this.getToken();
            SecurityMockServerConfigurers.mockOAuth2Client().accessToken(this.accessToken).principalName(token.getPrincipal().getName()).clientRegistration(this.clientRegistration).beforeServerCreated(builder);
            ((MockServerConfigurer)SecurityMockServerConfigurers.mockAuthentication((Authentication)token)).beforeServerCreated(builder);
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
            OAuth2AuthenticationToken token = this.getToken();
            SecurityMockServerConfigurers.mockOAuth2Client().accessToken(this.accessToken).principalName(token.getPrincipal().getName()).clientRegistration(this.clientRegistration).afterConfigureAdded(serverSpec);
            ((MockServerConfigurer)SecurityMockServerConfigurers.mockAuthentication((Authentication)token)).afterConfigureAdded(serverSpec);
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
            OAuth2AuthenticationToken token = this.getToken();
            SecurityMockServerConfigurers.mockOAuth2Client().accessToken(this.accessToken).principalName(token.getPrincipal().getName()).clientRegistration(this.clientRegistration).afterConfigurerAdded(builder, httpHandlerBuilder, connector);
            SecurityMockServerConfigurers.mockAuthentication((Authentication)token).afterConfigurerAdded(builder, httpHandlerBuilder, connector);
        }

        private ClientRegistration.Builder clientRegistrationBuilder() {
            return ClientRegistration.withRegistrationId((String)"test").authorizationGrantType(AuthorizationGrantType.PASSWORD).clientId("test-client").tokenUri("https://token-uri.example.org");
        }

        private OAuth2AuthenticationToken getToken() {
            OidcUser oidcUser = this.oidcUser.get();
            return new OAuth2AuthenticationToken((OAuth2User)oidcUser, oidcUser.getAuthorities(), this.clientRegistration.getRegistrationId());
        }

        private Collection<GrantedAuthority> getAuthorities() {
            if (this.authorities != null) {
                return this.authorities;
            }
            LinkedHashSet<GrantedAuthority> authorities = new LinkedHashSet<GrantedAuthority>();
            authorities.add((GrantedAuthority)new OidcUserAuthority(this.getOidcIdToken(), this.getOidcUserInfo()));
            for (String authority : this.accessToken.getScopes()) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("SCOPE_" + authority));
            }
            return authorities;
        }

        private OidcIdToken getOidcIdToken() {
            if (this.idToken != null) {
                return this.idToken;
            }
            return new OidcIdToken("id-token", null, null, Collections.singletonMap("sub", "user"));
        }

        private OidcUserInfo getOidcUserInfo() {
            return this.userInfo;
        }

        private OidcUser defaultPrincipal() {
            return new DefaultOidcUser(this.getAuthorities(), this.getOidcIdToken(), this.userInfo);
        }
    }

    public static final class OAuth2ClientMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private String registrationId = "test";
        private ClientRegistration clientRegistration;
        private String principalName = "user";
        private OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "access-token", null, null, Collections.singleton("read"));

        private OAuth2ClientMutator() {
        }

        private OAuth2ClientMutator(String registrationId) {
            this.registrationId = registrationId;
            this.clientRegistration((ClientRegistration.Builder c) -> {});
        }

        public OAuth2ClientMutator clientRegistration(ClientRegistration clientRegistration) {
            this.clientRegistration = clientRegistration;
            return this;
        }

        public OAuth2ClientMutator clientRegistration(Consumer<ClientRegistration.Builder> clientRegistrationConfigurer) {
            ClientRegistration.Builder builder = this.clientRegistrationBuilder();
            clientRegistrationConfigurer.accept(builder);
            this.clientRegistration = builder.build();
            return this;
        }

        public OAuth2ClientMutator principalName(String principalName) {
            Assert.notNull((Object)principalName, (String)"principalName cannot be null");
            this.principalName = principalName;
            return this;
        }

        public OAuth2ClientMutator accessToken(OAuth2AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            builder.filters(this.addAuthorizedClientFilter());
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
            httpHandlerBuilder.filters(this.addAuthorizedClientFilter());
        }

        private Consumer<List<WebFilter>> addAuthorizedClientFilter() {
            OAuth2AuthorizedClient client = this.getClient();
            return filters -> filters.add(0, (exchange, chain) -> {
                ServerOAuth2AuthorizedClientRepository authorizedClientRepository = OAuth2ClientServerTestUtils.getAuthorizedClientRepository(exchange);
                if (!(authorizedClientRepository instanceof TestOAuth2AuthorizedClientRepository)) {
                    authorizedClientRepository = new TestOAuth2AuthorizedClientRepository(authorizedClientRepository);
                    OAuth2ClientServerTestUtils.setAuthorizedClientRepository(exchange, authorizedClientRepository);
                }
                TestOAuth2AuthorizedClientRepository.enable(exchange);
                return authorizedClientRepository.saveAuthorizedClient(client, null, exchange).then(chain.filter(exchange));
            });
        }

        private OAuth2AuthorizedClient getClient() {
            Assert.notNull((Object)this.clientRegistration, (String)"Please specify a ClientRegistration via one of the clientRegistration methods");
            return new OAuth2AuthorizedClient(this.clientRegistration, this.principalName, this.accessToken);
        }

        private ClientRegistration.Builder clientRegistrationBuilder() {
            return ClientRegistration.withRegistrationId((String)this.registrationId).authorizationGrantType(AuthorizationGrantType.PASSWORD).clientId("test-client").clientSecret("test-secret").tokenUri("https://idp.example.org/oauth/token");
        }

        private static final class OAuth2ClientServerTestUtils {
            private static final ServerOAuth2AuthorizedClientRepository DEFAULT_CLIENT_REPO = new WebSessionServerOAuth2AuthorizedClientRepository();

            private OAuth2ClientServerTestUtils() {
            }

            static ServerOAuth2AuthorizedClientRepository getAuthorizedClientRepository(ServerWebExchange exchange) {
                ReactiveOAuth2AuthorizedClientManager manager = OAuth2ClientServerTestUtils.getOAuth2AuthorizedClientManager(exchange);
                if (manager == null) {
                    return DEFAULT_CLIENT_REPO;
                }
                if (manager instanceof DefaultReactiveOAuth2AuthorizedClientManager) {
                    return (ServerOAuth2AuthorizedClientRepository)ReflectionTestUtils.getField((Object)manager, (String)"authorizedClientRepository");
                }
                if (manager instanceof TestOAuth2AuthorizedClientManager) {
                    return ((TestOAuth2AuthorizedClientManager)manager).authorizedClientRepository;
                }
                return DEFAULT_CLIENT_REPO;
            }

            static void setAuthorizedClientRepository(ServerWebExchange exchange, ServerOAuth2AuthorizedClientRepository repository) {
                ReactiveOAuth2AuthorizedClientManager manager = OAuth2ClientServerTestUtils.getOAuth2AuthorizedClientManager(exchange);
                if (manager == null) {
                    return;
                }
                if (manager instanceof DefaultReactiveOAuth2AuthorizedClientManager) {
                    ReflectionTestUtils.setField((Object)manager, (String)"authorizedClientRepository", (Object)repository);
                    return;
                }
                if (!(manager instanceof TestOAuth2AuthorizedClientManager)) {
                    manager = new TestOAuth2AuthorizedClientManager(manager);
                    OAuth2ClientServerTestUtils.setOAuth2AuthorizedClientManager(exchange, manager);
                }
                TestOAuth2AuthorizedClientManager.enable(exchange);
                ((TestOAuth2AuthorizedClientManager)manager).authorizedClientRepository = repository;
            }

            static ReactiveOAuth2AuthorizedClientManager getOAuth2AuthorizedClientManager(ServerWebExchange exchange) {
                OAuth2AuthorizedClientArgumentResolver resolver = OAuth2ClientServerTestUtils.findResolver(exchange, OAuth2AuthorizedClientArgumentResolver.class);
                if (resolver == null) {
                    return authorizeRequest -> DEFAULT_CLIENT_REPO.loadAuthorizedClient(authorizeRequest.getClientRegistrationId(), authorizeRequest.getPrincipal(), exchange);
                }
                return (ReactiveOAuth2AuthorizedClientManager)ReflectionTestUtils.getField((Object)resolver, (String)"authorizedClientManager");
            }

            static void setOAuth2AuthorizedClientManager(ServerWebExchange exchange, ReactiveOAuth2AuthorizedClientManager manager) {
                OAuth2AuthorizedClientArgumentResolver resolver = OAuth2ClientServerTestUtils.findResolver(exchange, OAuth2AuthorizedClientArgumentResolver.class);
                if (resolver == null) {
                    return;
                }
                ReflectionTestUtils.setField((Object)resolver, (String)"authorizedClientManager", (Object)manager);
            }

            static <T extends HandlerMethodArgumentResolver> T findResolver(ServerWebExchange exchange, Class<T> resolverClass) {
                if (!ClassUtils.isPresent((String)"org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter", null)) {
                    return null;
                }
                return WebFluxClasspathGuard.findResolver(exchange, resolverClass);
            }

            private static class WebFluxClasspathGuard {
                private WebFluxClasspathGuard() {
                }

                static <T extends HandlerMethodArgumentResolver> T findResolver(ServerWebExchange exchange, Class<T> resolverClass) {
                    RequestMappingHandlerAdapter handlerAdapter = WebFluxClasspathGuard.getRequestMappingHandlerAdapter(exchange);
                    if (handlerAdapter == null) {
                        return null;
                    }
                    ArgumentResolverConfigurer configurer = handlerAdapter.getArgumentResolverConfigurer();
                    if (configurer == null) {
                        return null;
                    }
                    List resolvers = (List)ReflectionTestUtils.invokeGetterMethod((Object)configurer, (String)"customResolvers");
                    if (resolvers == null) {
                        return null;
                    }
                    for (HandlerMethodArgumentResolver resolver : resolvers) {
                        if (!resolverClass.isAssignableFrom(resolver.getClass())) continue;
                        return (T)resolver;
                    }
                    return null;
                }

                private static RequestMappingHandlerAdapter getRequestMappingHandlerAdapter(ServerWebExchange exchange) {
                    String[] names;
                    ApplicationContext context = exchange.getApplicationContext();
                    if (context != null && (names = context.getBeanNamesForType(RequestMappingHandlerAdapter.class)).length > 0) {
                        return (RequestMappingHandlerAdapter)context.getBean(names[0]);
                    }
                    return null;
                }
            }
        }

        static final class TestOAuth2AuthorizedClientRepository
        implements ServerOAuth2AuthorizedClientRepository {
            static final String TOKEN_ATTR_NAME = TestOAuth2AuthorizedClientRepository.class.getName().concat(".TOKEN");
            static final String ENABLED_ATTR_NAME = TestOAuth2AuthorizedClientRepository.class.getName().concat(".ENABLED");
            private final ServerOAuth2AuthorizedClientRepository delegate;

            TestOAuth2AuthorizedClientRepository(ServerOAuth2AuthorizedClientRepository delegate) {
                this.delegate = delegate;
            }

            public <T extends OAuth2AuthorizedClient> Mono<T> loadAuthorizedClient(String clientRegistrationId, Authentication principal, ServerWebExchange exchange) {
                if (this.isEnabled(exchange)) {
                    return Mono.just((Object)((OAuth2AuthorizedClient)exchange.getAttribute(TOKEN_ATTR_NAME)));
                }
                return this.delegate.loadAuthorizedClient(clientRegistrationId, principal, exchange);
            }

            public Mono<Void> saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal, ServerWebExchange exchange) {
                if (this.isEnabled(exchange)) {
                    exchange.getAttributes().put(TOKEN_ATTR_NAME, authorizedClient);
                    return Mono.empty();
                }
                return this.delegate.saveAuthorizedClient(authorizedClient, principal, exchange);
            }

            public Mono<Void> removeAuthorizedClient(String clientRegistrationId, Authentication principal, ServerWebExchange exchange) {
                if (this.isEnabled(exchange)) {
                    exchange.getAttributes().remove(TOKEN_ATTR_NAME);
                    return Mono.empty();
                }
                return this.delegate.removeAuthorizedClient(clientRegistrationId, principal, exchange);
            }

            static void enable(ServerWebExchange exchange) {
                exchange.getAttributes().put(ENABLED_ATTR_NAME, Boolean.TRUE);
            }

            boolean isEnabled(ServerWebExchange exchange) {
                return Boolean.TRUE.equals(exchange.getAttribute(ENABLED_ATTR_NAME));
            }
        }

        private static final class TestOAuth2AuthorizedClientManager
        implements ReactiveOAuth2AuthorizedClientManager {
            static final String ENABLED_ATTR_NAME = TestOAuth2AuthorizedClientManager.class.getName().concat(".ENABLED");
            private final ReactiveOAuth2AuthorizedClientManager delegate;
            private ServerOAuth2AuthorizedClientRepository authorizedClientRepository;

            TestOAuth2AuthorizedClientManager(ReactiveOAuth2AuthorizedClientManager delegate) {
                this.delegate = delegate;
            }

            public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizeRequest authorizeRequest) {
                ServerWebExchange exchange = (ServerWebExchange)authorizeRequest.getAttribute(ServerWebExchange.class.getName());
                if (this.isEnabled(exchange)) {
                    return this.authorizedClientRepository.loadAuthorizedClient(authorizeRequest.getClientRegistrationId(), authorizeRequest.getPrincipal(), exchange);
                }
                return this.delegate.authorize(authorizeRequest);
            }

            static void enable(ServerWebExchange exchange) {
                exchange.getAttributes().put(ENABLED_ATTR_NAME, Boolean.TRUE);
            }

            boolean isEnabled(ServerWebExchange exchange) {
                return Boolean.TRUE.equals(exchange.getAttribute(ENABLED_ATTR_NAME));
            }
        }
    }

    public static final class CsrfMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private CsrfMutator() {
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
            CsrfWebFilter filter = new CsrfWebFilter();
            filter.setRequireCsrfProtectionMatcher(e -> ServerWebExchangeMatcher.MatchResult.notMatch());
            httpHandlerBuilder.filters(filters -> filters.add(0, filter));
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
        }
    }

    private static class MutatorFilter
    implements WebFilter {
        public static final String ATTRIBUTE_NAME = "context";

        private MutatorFilter() {
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain webFilterChain) {
            Supplier context = (Supplier)exchange.getAttribute(ATTRIBUTE_NAME);
            if (context != null) {
                exchange.getAttributes().remove(ATTRIBUTE_NAME);
                return webFilterChain.filter(exchange).contextWrite((ContextView)ReactiveSecurityContextHolder.withSecurityContext((Mono)((Mono)context.get())));
            }
            return webFilterChain.filter(exchange);
        }
    }

    private static final class SetupMutatorFilter
    implements WebFilter {
        private final Supplier<Mono<SecurityContext>> context;

        private SetupMutatorFilter(Supplier<Mono<SecurityContext>> context) {
            this.context = context;
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain webFilterChain) {
            exchange.getAttributes().computeIfAbsent("context", key -> this.context);
            return webFilterChain.filter(exchange);
        }
    }
}

