/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.Arrays;
import java.util.List;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.handler.DefaultWebFilterChain;
import org.springframework.web.server.handler.FilteringWebHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebFilterChainProxy
implements WebFilter {
    private final List<SecurityWebFilterChain> filters;

    public WebFilterChainProxy(List<SecurityWebFilterChain> filters) {
        this.filters = filters;
    }

    public WebFilterChainProxy(SecurityWebFilterChain ... filters) {
        this.filters = Arrays.asList(filters);
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return Flux.fromIterable(this.filters).filterWhen(securityWebFilterChain -> securityWebFilterChain.matches(exchange)).next().switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(securityWebFilterChain -> securityWebFilterChain.getWebFilters().collectList()).map(filters -> new FilteringWebHandler(webHandler -> chain.filter(webHandler), filters)).map(handler -> new DefaultWebFilterChain((WebHandler)handler, new WebFilter[0])).flatMap(securedChain -> securedChain.filter(exchange));
    }
}

