/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.DeferredCsrfToken;
import org.springframework.util.Assert;

public final class CsrfAuthenticationStrategy
implements SessionAuthenticationStrategy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final CsrfTokenRepository tokenRepository;
    private CsrfTokenRequestHandler requestHandler = new CsrfTokenRequestAttributeHandler();

    public CsrfAuthenticationStrategy(CsrfTokenRepository tokenRepository) {
        Assert.notNull((Object)tokenRepository, (String)"tokenRepository cannot be null");
        this.tokenRepository = tokenRepository;
    }

    public void setRequestHandler(CsrfTokenRequestHandler requestHandler) {
        Assert.notNull((Object)requestHandler, (String)"requestHandler cannot be null");
        this.requestHandler = requestHandler;
    }

    @Override
    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws SessionAuthenticationException {
        this.tokenRepository.saveToken(null, request, response);
        DeferredCsrfToken deferredCsrfToken = this.tokenRepository.loadDeferredToken(request, response);
        this.requestHandler.handle(request, response, deferredCsrfToken::get);
        this.logger.debug((Object)"Replaced CSRF Token");
    }
}

