/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.channel;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.channel.ChannelEntryPoint;
import org.springframework.security.web.access.channel.ChannelProcessor;
import org.springframework.security.web.access.channel.RetryWithHttpEntryPoint;
import org.springframework.util.Assert;

public class InsecureChannelProcessor
implements InitializingBean,
ChannelProcessor {
    private ChannelEntryPoint entryPoint = new RetryWithHttpEntryPoint();
    private String insecureKeyword = "REQUIRES_INSECURE_CHANNEL";

    public void afterPropertiesSet() {
        Assert.hasLength((String)this.insecureKeyword, (String)"insecureKeyword required");
        Assert.notNull((Object)this.entryPoint, (String)"entryPoint required");
    }

    @Override
    public void decide(FilterInvocation invocation, Collection<ConfigAttribute> config) throws IOException, ServletException {
        Assert.isTrue((invocation != null && config != null ? 1 : 0) != 0, (String)"Nulls cannot be provided");
        for (ConfigAttribute attribute : config) {
            if (!this.supports(attribute) || !invocation.getHttpRequest().isSecure()) continue;
            this.entryPoint.commence(invocation.getRequest(), invocation.getResponse());
        }
    }

    public ChannelEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public String getInsecureKeyword() {
        return this.insecureKeyword;
    }

    public void setEntryPoint(ChannelEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setInsecureKeyword(String secureKeyword) {
        this.insecureKeyword = secureKeyword;
    }

    @Override
    public boolean supports(ConfigAttribute attribute) {
        return attribute != null && attribute.getAttribute() != null && attribute.getAttribute().equals(this.getInsecureKeyword());
    }
}

