/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.core.annotation.CurrentSecurityContext;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CurrentSecurityContextArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    private ExpressionParser parser = new SpelExpressionParser();
    private BeanResolver beanResolver;

    public CurrentSecurityContextArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        Assert.notNull((Object)beanResolver, (String)"beanResolver cannot be null");
        this.beanResolver = beanResolver;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return this.isMonoSecurityContext(parameter) || this.findMethodAnnotation(CurrentSecurityContext.class, parameter) != null;
    }

    private boolean isMonoSecurityContext(MethodParameter parameter) {
        boolean isParameterPublisher = Publisher.class.isAssignableFrom(parameter.getParameterType());
        if (isParameterPublisher) {
            ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)parameter);
            Class genericType = resolvableType.resolveGeneric(new int[]{0});
            if (genericType == null) {
                return false;
            }
            return SecurityContext.class.isAssignableFrom(genericType);
        }
        return false;
    }

    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(parameter.getParameterType());
        Mono reactiveSecurityContext = ReactiveSecurityContextHolder.getContext();
        if (reactiveSecurityContext == null) {
            return null;
        }
        return reactiveSecurityContext.flatMap(securityContext -> {
            Mono resolvedSecurityContext = Mono.justOrEmpty((Object)this.resolveSecurityContext(parameter, (SecurityContext)securityContext));
            return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)resolvedSecurityContext)) : resolvedSecurityContext;
        });
    }

    private Object resolveSecurityContext(MethodParameter parameter, SecurityContext securityContext) {
        CurrentSecurityContext annotation = this.findMethodAnnotation(CurrentSecurityContext.class, parameter);
        if (annotation != null) {
            return this.resolveSecurityContextFromAnnotation(annotation, parameter, securityContext);
        }
        return securityContext;
    }

    private Object resolveSecurityContextFromAnnotation(CurrentSecurityContext annotation, MethodParameter parameter, Object securityContext) {
        Object securityContextResult = securityContext;
        String expressionToParse = annotation.expression();
        if (StringUtils.hasLength((String)expressionToParse)) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject(securityContext);
            context.setVariable("this", securityContext);
            context.setBeanResolver(this.beanResolver);
            Expression expression = this.parser.parseExpression(expressionToParse);
            securityContextResult = expression.getValue((EvaluationContext)context);
        }
        if (this.isInvalidType(parameter, securityContextResult)) {
            if (annotation.errorOnInvalidType()) {
                throw new ClassCastException(securityContextResult + " is not assignable to " + parameter.getParameterType());
            }
            return null;
        }
        return securityContextResult;
    }

    private boolean isInvalidType(MethodParameter parameter, Object reactiveSecurityContext) {
        if (reactiveSecurityContext == null) {
            return false;
        }
        Class typeToCheck = parameter.getParameterType();
        boolean isParameterPublisher = Publisher.class.isAssignableFrom(parameter.getParameterType());
        if (isParameterPublisher) {
            ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)parameter);
            Class genericType = resolvableType.resolveGeneric(new int[]{0});
            if (genericType == null) {
                return false;
            }
            typeToCheck = genericType;
        }
        return !typeToCheck.isAssignableFrom(reactiveSecurityContext.getClass());
    }

    private <T extends Annotation> T findMethodAnnotation(Class<T> annotationClass, MethodParameter parameter) {
        Annotation[] annotationsToSearch;
        Annotation annotation = parameter.getParameterAnnotation(annotationClass);
        if (annotation != null) {
            return (T)annotation;
        }
        for (Annotation toSearch : annotationsToSearch = parameter.getParameterAnnotations()) {
            annotation = AnnotationUtils.findAnnotation(toSearch.annotationType(), annotationClass);
            if (annotation == null) continue;
            return (T)annotation;
        }
        return null;
    }
}

