/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.method.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.annotation.CurrentSecurityContext;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public final class CurrentSecurityContextArgumentResolver
implements HandlerMethodArgumentResolver {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private final Map<MethodParameter, Annotation> cachedAttributes = new ConcurrentHashMap<MethodParameter, Annotation>();
    private ExpressionParser parser = new SpelExpressionParser();
    private SecurityAnnotationScanner<CurrentSecurityContext> scanner = SecurityAnnotationScanners.requireUnique(CurrentSecurityContext.class);
    private BeanResolver beanResolver;

    public boolean supportsParameter(MethodParameter parameter) {
        return SecurityContext.class.isAssignableFrom(parameter.getParameterType()) || this.findMethodAnnotation(parameter) != null;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        SecurityContext securityContext = this.securityContextHolderStrategy.getContext();
        if (securityContext == null) {
            return null;
        }
        CurrentSecurityContext annotation = (CurrentSecurityContext)this.findMethodAnnotation(parameter);
        if (annotation != null) {
            return this.resolveSecurityContextFromAnnotation(parameter, annotation, securityContext);
        }
        return securityContext;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        Assert.notNull((Object)beanResolver, (String)"beanResolver cannot be null");
        this.beanResolver = beanResolver;
    }

    public void setTemplateDefaults(AnnotationTemplateExpressionDefaults templateDefaults) {
        this.scanner = SecurityAnnotationScanners.requireUnique(CurrentSecurityContext.class, (AnnotationTemplateExpressionDefaults)templateDefaults);
    }

    private Object resolveSecurityContextFromAnnotation(MethodParameter parameter, CurrentSecurityContext annotation, SecurityContext securityContext) {
        Object securityContextResult = securityContext;
        String expressionToParse = annotation.expression();
        if (StringUtils.hasLength((String)expressionToParse)) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject((Object)securityContext);
            context.setVariable("this", (Object)securityContext);
            context.setBeanResolver(this.beanResolver);
            Expression expression = this.parser.parseExpression(expressionToParse);
            securityContextResult = expression.getValue((EvaluationContext)context);
        }
        if (securityContextResult != null && !parameter.getParameterType().isAssignableFrom(securityContextResult.getClass())) {
            if (annotation.errorOnInvalidType()) {
                throw new ClassCastException(securityContextResult + " is not assignable to " + parameter.getParameterType());
            }
            return null;
        }
        return securityContextResult;
    }

    private <T extends Annotation> T findMethodAnnotation(MethodParameter parameter) {
        return (T)this.cachedAttributes.computeIfAbsent(parameter, methodParameter -> this.scanner.scan(methodParameter.getParameter()));
    }
}

