/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.util.Assert;

public final class SessionInformationExpiredEvent
extends ApplicationEvent {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final @Nullable FilterChain filterChain;

    public SessionInformationExpiredEvent(SessionInformation sessionInformation, HttpServletRequest request, HttpServletResponse response) {
        this(sessionInformation, request, response, null);
    }

    public SessionInformationExpiredEvent(SessionInformation sessionInformation, HttpServletRequest request, HttpServletResponse response, @Nullable FilterChain filterChain) {
        super((Object)sessionInformation);
        Assert.notNull((Object)request, (String)"request cannot be null");
        Assert.notNull((Object)response, (String)"response cannot be null");
        this.request = request;
        this.response = response;
        this.filterChain = filterChain;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public SessionInformation getSessionInformation() {
        return (SessionInformation)this.getSource();
    }

    public @Nullable FilterChain getFilterChain() {
        return this.filterChain;
    }
}

