/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class NegatedRequestMatcher
implements RequestMatcher {
    private final RequestMatcher requestMatcher;

    public NegatedRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        return !this.requestMatcher.matches(request);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NegatedRequestMatcher)) {
            return false;
        }
        NegatedRequestMatcher that = (NegatedRequestMatcher)obj;
        return Objects.equals(this.requestMatcher, that.requestMatcher);
    }

    public int hashCode() {
        return Objects.hash(this.requestMatcher);
    }

    public String toString() {
        return "Not [" + String.valueOf(this.requestMatcher) + "]";
    }
}

